/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.JiraMode;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.EMAIL})
@LoginAs(user="admin")
public class TestSendBulkMail
extends EmailBaseFuncTestCase {
    private static final String LINK_TEXT_CONFIG_NEW_SMTP = "Configure new SMTP mail server";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_FROM = "from";
    private static final String FIELD_PREFIX = "prefix";
    private static final String FIELD_SERVER_NAME = "serverName";
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String BUTTON_ADD = "Add";
    private static final Map<String, String> ROLE_TO_ID = ImmutableMap.of((Object)"Administrators", (Object)"10002", (Object)"Developers", (Object)"10001", (Object)"Users", (Object)"10000");
    private static final String TEST_ROLES_PROJECT = "Test Roles Project";
    private static final String TEST_ROLES_PROJECT_KEY = "TRP";
    private static final String TEST_GROUP = "testGroup";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testRolesSelectedAsDefault() {
        this.setUpDummyMailServer();
        this.administration.sendBulkMail().goTo();
        this.tester.assertRadioOptionSelected("sendToRoles", "true");
    }

    @Test
    public void testErrors() {
        this.setUpDummyMailServer();
        long projectId = this.administration.project().addProject(TEST_ROLES_PROJECT, TEST_ROLES_PROJECT_KEY, "admin");
        this.createUserAndAddToRole("bob", TEST_ROLES_PROJECT, projectId, "Developers");
        this.administration.sendBulkMail().goTo();
        this.tester.setFormElement("replyTo", "TEST@TEST.NET");
        this.tester.setFormElement("subject", "TEST");
        this.tester.setFormElement("message", "TEST");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please select at least one project and one role.");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please select at least one role.");
        this.administration.sendBulkMail().goTo();
        this.tester.selectOption("roles", "Administrators");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please select at least one project.");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "The chosen project/role combination(s) have no members.");
        this.administration.usersAndGroups().addGroup(TEST_GROUP);
        this.administration.sendBulkMail().goTo();
        this.tester.checkRadioOption("sendToRoles", "false");
        this.tester.setFormElement("replyTo", "TEST@TEST.NET");
        this.tester.setFormElement("subject", "TEST");
        this.tester.setFormElement("message", "TEST");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please select at least one group.");
        this.tester.selectOption("groups", TEST_GROUP);
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "The chosen group(s) have no members.");
        this.administration.sendBulkMail().goTo();
        this.tester.selectOption("projects", "homosapien");
        this.tester.selectOption("roles", "Administrators");
        this.tester.setFormElement("replyTo", "not a valid e-mail address");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.locator.page(), "Invalid email address format.");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please specify a subject.");
        this.textAssertions.assertTextPresent(this.locator.page(), "Please provide a message body.");
    }

    @Test
    public void testSubjectIsNotEvaluated() throws Exception {
        this.configureAndStartSmtpServer();
        this.backdoor.generalConfiguration().setJiraMode(JiraMode.PRIVATE).setContactAdminFormOn();
        String subject = "><& #set($v=\"s\"); $v.getClass().forName(\"java.net.InetAddress\").getMethod(\"getLocalHost\").invoke(null)";
        long projectId = this.administration.project().addProject(TEST_ROLES_PROJECT, TEST_ROLES_PROJECT_KEY, "admin");
        this.createUserAndAddToRole("bob", TEST_ROLES_PROJECT, projectId, "Developers");
        this.administration.sendBulkMail().goTo();
        this.tester.setFormElement("replyTo", "TEST@TEST.NET");
        this.tester.setFormElement("subject", subject);
        this.tester.setFormElement("message", "something");
        this.tester.selectOption("projects", TEST_ROLES_PROJECT);
        this.tester.selectOption("roles", "Developers");
        this.tester.submit("Send");
        this.textAssertions.assertTextPresent(this.mailService.getReceivedMessage().getSubject(), subject);
    }

    private void createUserAndAddToRole(String userName, String projectName, long projectId, String role) {
        this.administration.usersAndGroups().addUser(userName, userName, userName, userName + "@atlassian.com");
        this.administration.usersAndGroups().gotoViewUser(userName);
        this.tester.clickLink("viewprojectroles_link");
        this.tester.clickLinkWithText("Edit Project Roles");
        if (this.tester.getDialog().isLinkPresent(projectName)) {
            this.tester.clickLinkWithText(projectName);
        }
        String targetCheckboxId = projectId + "_" + ROLE_TO_ID.get(role);
        this.tester.checkCheckbox(targetCheckboxId, "on");
        this.tester.submit("Save");
    }

    private void setUpDummyMailServer() {
        this.administration.mailServers().Smtp().goTo();
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.tester.setFormElement(FIELD_NAME, "name SMTP");
        this.tester.setFormElement(FIELD_FROM, "from@atlassian.com");
        this.tester.setFormElement(FIELD_PREFIX, FIELD_PREFIX);
        this.tester.setFormElement(FIELD_SERVER_NAME, "server name");
        this.tester.setFormElement("authenticationMethod", FIELD_PASSWORD);
        this.tester.setFormElement(FIELD_USERNAME, FIELD_USERNAME);
        this.tester.setFormElement(FIELD_PASSWORD, FIELD_PASSWORD);
        this.tester.submit(BUTTON_ADD);
    }

    private static final class DummyMailServer {
        private static final String NAME = "name SMTP";
        private static final String FROM_ADDRESS = "from@atlassian.com";
        private static final String EMAIL_PREFIX = "prefix";
        private static final String SERVER_NAME = "server name";
        private static final String AUTHENTICATION_METHOD = "password";
        private static final String USER_NAME = "username";
        private static final String PASSWORD = "password";

        private DummyMailServer() {
        }
    }
}

