/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.failover;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.ao.TestActiveObjects;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class TestFailoverPgpool
extends BaseJiraFuncTest {
    @Inject
    private FuncTestLogger logger;

    @Test
    public void testDownUpNode() throws IOException, InterruptedException {
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new TextListener(System.out));
        Result testResults = junit.run(new Class[]{TestActiveObjects.class});
        Assert.assertTrue((boolean)testResults.wasSuccessful());
        this.logger.log((Object)"Shutdown the primary node `pg-0`");
        Assert.assertEquals((long)0L, (long)this.stopContainer("pg-0"));
        this.logger.log((Object)"Waiting for promoting a new primary node ...");
        TimeUnit.SECONDS.sleep(15L);
        testResults = junit.run(new Class[]{TestActiveObjects.class});
        Assert.assertTrue((boolean)testResults.wasSuccessful());
        this.logger.log((Object)"Up and connecting pg-0 as a standby node");
        Assert.assertEquals((long)0L, (long)this.startContainer("pg-0"));
        testResults = junit.run(new Class[]{TestActiveObjects.class});
        Assert.assertTrue((boolean)testResults.wasSuccessful());
    }

    private int startContainer(String container) throws IOException, InterruptedException {
        return this.execCommand(("docker container start " + container).split(" "));
    }

    private int stopContainer(String container) throws IOException, InterruptedException {
        return this.execCommand(("docker container stop " + container).split(" "));
    }

    private int execCommand(String[] commandArray) throws IOException, InterruptedException {
        return new ProcessBuilder(new String[0]).command(commandArray).start().waitFor();
    }
}

