/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.Screens;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.FIELDS, Category.ISSUE_TYPES, Category.SCREENS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestFieldScreens
extends BaseJiraFuncTest {
    private static final String ADDED_SCREEN_NAME = "Test Add Screen";
    private static final String ADDED_SCREEN_SCHEME_NAME = "Test Add Screen Scheme";
    private static final String COPIED_SCREEN_SCHEME_NAME = "Test Copy Screen Scheme";
    private static final String ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Add Issue Type Screen Scheme";
    private static final String COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Copy Issue Tyep Screen Scheme";
    private static final String CUSTOM_FIELD_NAME = "Animal";
    private String issueKey;
    private String issueKey2;
    private String customFieldId;
    @Inject
    private Screens screens;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.navigation.login("admin");
        this.resetSettings();
        this.customFieldId = this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME, "", CustomFields.builtInCustomFieldKey("textfield"), null);
        this.issueKey = this.backdoor.issues().createIssue("HSP", "test field screen", "admin", "Minor", "Bug").key();
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().description("test description for field screens").environment("priority is added to assign issue screen"));
        this.createIssueWithCustomField();
    }

    @Test
    public void testFieldScreens() {
        this.fieldScreensAddFieldToFieldScreen();
        this.fieldScreensSetFieldInWorkflow();
        this.fieldScreensRemoveFieldFromFieldScreen();
        this.fieldScreensAddScreen();
        this.fieldScreensAddScreenCancel();
        this.fieldScreensAddScreenWithDuplicateName();
        this.fieldScreensAddScreenWithInvalidName();
        this.fieldScreensStandardScreens();
        this.fieldScreensAddScreenScheme();
        this.fieldScreensAddScreenSchemeWithDuplicateName();
        this.fieldScreensAddScreenSchemeWithInvalidName();
        this.fieldScreensAddIssueTypeScreenScheme();
        this.fieldScreensAddIssueTypeScreenSchemeWithDuplicateName();
        this.fieldScreensAddIssueTypeToScreenAssociation();
        this.fieldScreensProjectScreenSchemes();
        this.fieldScreensIssueTypeScreenSchemes();
        this.fieldScreensCopyIssueTypeScreenSchemes();
        this.fieldScreensDeleteIssueTypeScreenSchemes();
        this.fieldScreensCopyScreenScheme();
        this.fieldScreensDeleteScreenScheme();
    }

    @Test
    public void testDeleteIssueTypeSchemeFailsWhenAssignedToProject() {
        Long issueTypeScreenSchemeId = this.backdoor.issueTypeScreenSchemes().createScheme("DELETEME", "blah", 1L);
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        this.backdoor.project().setIssueTypeScreenScheme(10000L, issueTypeScreenSchemeId);
        this.tester.clickLink("delete_issuetypescreenscheme_10000");
        this.tester.assertTextPresent("Cannot delete an issue type screen scheme that is being used by a project");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete an issue type screen scheme that is being used by a project");
    }

    private void fieldScreensAddFieldToFieldScreen() {
        this.backdoor.screens().addFieldToScreen("Workflow Screen", CUSTOM_FIELD_NAME);
        this.backdoor.screens().addFieldToScreen("Workflow Screen", "Issue Type");
    }

    private void fieldScreensSetFieldInWorkflow() {
        this.navigation.issue().gotoIssue(this.issueKey);
        this.workflowUtil.clickAction("action_id_2");
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.workflowUtil.clickAction("action_id_3");
        this.tester.setFormElement(this.customFieldId, "Polar Bear");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    private void fieldScreensRemoveFieldFromFieldScreen() {
        String[] fieldNames = new String[]{CUSTOM_FIELD_NAME, "Issue Type"};
        this.removeFieldFromFieldScreen("Workflow Screen", fieldNames);
        WebTable webTable = this.assertions.getTableAssertions().getWebTable("field_table");
        if (webTable != null) {
            String text = webTable.getCellAsText(1, 1);
            Assert.fail((String)("Field was not removed around here: [" + text + "]"));
        }
    }

    private void removeFieldFromFieldScreen(String screenName, String[] fieldNames) {
        this.logger.log((Object)"Removing Fields from field screen.");
        this.gotoFieldScreen(screenName);
        for (String fieldName : fieldNames) {
            this.backdoor.screens().removeFieldFromScreen(screenName, fieldName);
        }
    }

    private void gotoFieldScreen(String screenName) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
    }

    private void fieldScreensAddScreen() {
        this.screens.addScreen(ADDED_SCREEN_NAME, "");
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
    }

    private void fieldScreensAddScreenCancel() {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREENS.getUrl());
        this.tester.clickLink("add-field-screen");
        this.tester.clickLink("field-screen-add-cancel");
        this.textAssertions.assertTextPresent(this.locator.css("header h2"), "View Screens");
    }

    private void fieldScreensAddScreenWithDuplicateName() {
        this.screens.addScreen(ADDED_SCREEN_NAME, "");
        this.tester.assertTextPresent("A Screen with this name already exists.");
    }

    private void fieldScreensAddScreenWithInvalidName() {
        this.screens.addScreen("", "");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensAddScreenScheme() {
        this.screens.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "");
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_SCREEN_SCHEME.getUrl());
        this.tester.assertLinkPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddScreenSchemeWithDuplicateName() {
        this.screens.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "");
        this.tester.assertTextPresent("A Screen Scheme with this name already exists.");
    }

    private void fieldScreensAddScreenSchemeWithInvalidName() {
        this.screens.addFieldScreenScheme("", "");
        this.tester.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensCopyScreenScheme() {
        this.screens.copyFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, COPIED_SCREEN_SCHEME_NAME, "");
        this.tester.clickLink("configure_fieldscreenscheme_Test Copy Screen Scheme");
        this.tester.assertLinkPresent("edit_fieldscreenscheme_Default");
    }

    private void fieldScreensDeleteScreenScheme() {
        this.screens.deleteFieldScreenScheme(COPIED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkNotPresent("delete_fieldscreenscheme_Test Copy Screen Scheme");
        this.screens.deleteFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkNotPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenScheme() {
        this.screens.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", "Default Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenSchemeWithDuplicateName() {
        this.screens.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", "Default Screen Scheme");
        this.tester.assertTextPresent("A scheme with this name already exists.");
    }

    private void fieldScreensAddIssueTypeToScreenAssociation() {
        this.addIssueTypeToScreenAssociation("10000", "Bug", ADDED_SCREEN_SCHEME_NAME);
        this.tester.assertLinkPresent("delete_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensCopyIssueTypeScreenSchemes() {
        this.screens.copyIssueTypeFieldScreenSchemeName("10000", COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "");
        this.tester.clickLink("configure_issuetypescreenscheme_10001");
        this.tester.assertLinkPresent("edit_issuetypescreenschemeentity_default");
        this.tester.assertLinkPresent("edit_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensDeleteIssueTypeScreenSchemes() {
        this.screens.deleteIssueTypeFieldScreenScheme("10001");
        this.tester.assertLinkNotPresent("delete_issuetypescreenscheme_10001");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
        this.screens.deleteIssueTypeFieldScreenScheme("10000");
        this.tester.assertLinkNotPresent("delete_issuetypescreenscheme_10000");
    }

    private void addIssueTypeToScreenAssociation(String issueTypeSchemeId, String issueType, String screenSchemeName) {
        this.gotoIssueTypeScreenScheme(issueTypeSchemeId);
        this.tester.clickLink("add-issue-type-screen-scheme-configuration-association");
        this.tester.selectOption("issueTypeId", issueType);
        this.tester.selectOption("fieldScreenSchemeId", screenSchemeName);
        this.tester.submit("Add");
    }

    private void associateIssueTypeScreenSchemeToProject(String projectName, String screenScheme) {
        Project project = this.getProjectByName(projectName);
        this.tester.gotoPage("/secure/project/SelectIssueTypeScreenScheme!default.jspa?projectId=" + project.id);
        this.tester.selectOption("schemeId", screenScheme);
        this.tester.submit("Associate");
    }

    private Project getProjectByName(String projectName) {
        List projects = new ProjectClient((JIRAEnvironmentData)this.environmentData).getProjects();
        return projects.stream().filter(p -> p.name.equals(projectName)).findFirst().orElse(null);
    }

    private void gotoIssueTypeScreenScheme(String schemeName) {
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        this.tester.clickLink("configure_issuetypescreenscheme_" + schemeName);
    }

    private void fieldScreensIssueTypeScreenSchemes() {
        this.logger.log((Object)"Check schemes using issue type based schemes");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, "Summary");
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "NDT", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue", ADDED_SCREEN_NAME);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue", ADDED_SCREEN_NAME);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue", ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Improvement", this.issueKey2);
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue");
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue");
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue");
        this.checkNoScreenScheme("neanderthal", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
    }

    private void fieldScreensProjectScreenSchemes() {
        this.logger.log((Object)"Check screens using project based schemes");
        this.associateIssueTypeScreenSchemeToProject("homosapien", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, "Summary");
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue", ADDED_SCREEN_NAME);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue", ADDED_SCREEN_NAME);
        this.screens.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue", ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Bug", this.issueKey2);
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Create Issue");
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "View Issue");
        this.screens.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, "Edit Issue");
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
        this.associateIssueTypeScreenSchemeToProject("homosapien", "Default Issue Type Screen Scheme");
    }

    private void fieldScreensStandardScreens() {
        this.logger.log((Object)"Check screens for standard settings");
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, "Summary");
        this.backdoor.screens().addFieldToScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme("Default Screen Scheme", "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme("Default Screen Scheme", "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme("Default Screen Scheme", "homosapien", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
    }

    private void resetSettings() {
        if (this.administration.project().projectWithKeyExists("HSP")) {
            this.logger.log((Object)"Project homosapien exists");
        } else {
            this.administration.project().addProject("homosapien", "HSP", "admin");
        }
        if (this.administration.project().projectWithKeyExists("NDT")) {
            this.logger.log((Object)"Project: neanderthal exists");
        } else {
            this.administration.project().addProject("neanderthal", "NDT", "admin");
        }
        this.associateIssueTypeScreenSchemeToProject("homosapien", "Default Issue Type Screen Scheme");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", "Default Issue Type Screen Scheme");
        this.removeAllRemainingIssueTypeScreenSchemes();
        this.removeAllCustomFields();
        this.screens.removeAllRemainingScreenAssociationsFromDefault();
        this.removeAllRemainingIssueTypeScreenSchemes();
        this.screens.removeAllRemainingFieldScreens();
    }

    private void removeAllCustomFields() {
        List customFields = this.backdoor.customFields().getCustomFields();
        customFields.forEach(cfResponse -> this.backdoor.customFields().deleteCustomField(cfResponse.id));
    }

    public void removeAllRemainingIssueTypeScreenSchemes() {
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        if (this.tester.getDialog().isLinkPresentWithText("Delete")) {
            this.tester.clickLinkWithText("Delete");
            this.tester.submit("Delete");
            this.removeAllRemainingIssueTypeScreenSchemes();
        }
    }

    private void createIssueWithCustomField() {
        this.backdoor.screens().addFieldToScreen("Default Screen", CUSTOM_FIELD_NAME);
        this.navigation.issue().goToCreateIssueForm("neanderthal", "Improvement");
        this.tester.setFormElement("summary", "This is an issue in project 2 with a custom field");
        this.tester.setFormElement(this.customFieldId, "Elephant");
        this.tester.submit();
        this.issueKey2 = this.getIssueKey("NDT");
        this.removeFieldFromFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME});
    }

    private String getIssueKey(String projectKey) {
        try {
            String text = this.tester.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("[" + projectKey) + 1;
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            return text.substring(projectIdLocation, endOfIssueKey);
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return null;
        }
    }

    private void checkNoScreenScheme(String project, String issueType, String issueKeyCustomField) {
        this.logger.log((Object)"Checking scheme association for with no scheme selected");
        this.navigation.issue().goToCreateIssueForm(project, issueType);
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.tester.submit();
        this.navigation.issue().gotoIssue(issueKeyCustomField);
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent(this.customFieldId);
    }

    private String checkCreateIssueScreenScheme(String screenScheme, String project, String project_key, String issueType) {
        this.logger.log((Object)"Checking scheme association for Create");
        this.screens.addIssueOperationToScreenAssociation(screenScheme, "Create Issue", ADDED_SCREEN_NAME);
        this.navigation.issue().goToCreateIssueForm(project, issueType);
        this.tester.setFormElement("summary", "This is a test to see if field is shown");
        this.tester.setFormElement(this.customFieldId, "Elephant");
        this.tester.submit();
        this.tester.assertTextNotPresent("Elephant");
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.getIssueKey(project_key);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.screens.deleteIssueOperationFromScreenAssociation(screenScheme, "Create Issue");
        return issueKeyCustomField;
    }

    private void checkViewIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        this.logger.log((Object)"Checking scheme association for View");
        this.screens.addIssueOperationToScreenAssociation(screenScheme, "View Issue", ADDED_SCREEN_NAME);
        this.navigation.issue().goToCreateIssueForm(project, issueType);
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.navigation.issue().gotoIssue(issueKeyCustomField);
        this.tester.assertTextPresent("Elephant");
        this.tester.assertTextPresent(CUSTOM_FIELD_NAME);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.screens.deleteIssueOperationFromScreenAssociation(screenScheme, "View Issue");
    }

    private void checkEditIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        this.logger.log((Object)"Checking scheme association for Edit");
        this.screens.addIssueOperationToScreenAssociation(screenScheme, "Edit Issue", ADDED_SCREEN_NAME);
        this.navigation.issue().goToCreateIssueForm(project, issueType);
        this.tester.assertFormElementNotPresent(this.customFieldId);
        this.navigation.issue().gotoIssue(issueKeyCustomField);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement(this.customFieldId, "Whale");
        this.tester.submit();
        this.tester.assertTextNotPresent("Whale");
        this.tester.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.screens.deleteIssueOperationFromScreenAssociation(screenScheme, "Edit Issue");
    }
}

