/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@LoginAs(user="admin")
public class TestResolutionDateField
extends BaseJiraFuncTest {
    protected static final String ISSUE_STATUS_VALUE_ID = "opsbar-transitions_more";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestResolutionDateField.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testViewIssuePage() {
        this.navigation.issue().viewIssue("HSP-1");
        AbstractLocator locator = new XPathLocator(this.tester, "//header//h2");
        this.textAssertions.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextNotPresent(locator, "Resolved");
        this.navigation.issue().viewIssue("HSP-2");
        locator = new XPathLocator(this.tester, "//header//h2");
        this.textAssertions.assertTextPresent(locator, "Second test issue");
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextPresent(locator, "Resolved");
    }

    @Test
    public void testResolveIssueUpdatesDate() {
        this.navigation.issue().viewIssue("HSP-1");
        AbstractLocator locator = new XPathLocator(this.tester, "//header//h2");
        this.textAssertions.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextNotPresent(locator, "Resolved");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new XPathLocator(this.tester, "//header//h2");
        this.textAssertions.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId("issuetable").getCellAsText(2, 11).trim();
        Assert.assertTrue((resolvedCell.length() > 0 ? 1 : 0) != 0);
        this.navigation.issue().viewIssue("HSP-1");
        this.workflowUtil.clickAction("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        locator = new XPathLocator(this.tester, "//header//h2");
        this.textAssertions.assertTextPresent(locator, "First test issue");
        locator = new IdLocator(this.tester, ISSUE_STATUS_VALUE_ID);
        this.textAssertions.assertTextNotPresent(locator, "Resolved");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    @Test
    public void testIssueNavigatorColumns() {
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 0, 11), "Resolved");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 1), "HSP-2");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 11), "14/Oct/08");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 2, 1), "HSP-1");
        this.assertTableCellEmpty("issuetable", 2, 11);
    }

    @Test
    public void testIssueViews() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextNotPresent("Resolved:");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextPresent("Resolved:");
    }

    private void assertTableCellEmpty(String tableId, int row, int col) {
        String resolvedCell = this.tester.getDialog().getWebTableBySummaryOrId(tableId).getCellAsText(row, col).trim();
        Assert.assertTrue((resolvedCell.length() == 0 ? 1 : 0) != 0);
    }
}

