/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public class TestFilterWarnings
extends BaseJiraFuncTest {
    private static final String NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED = "No mail server is currently configured. Notifications will not be sent.";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        String filter = this.backdoor.filters().createFilter("", "Test Filter");
        this.navigation.manageFilters().addSubscription(Integer.parseInt(filter, 10));
    }

    private void addSubscription() {
        this.tester.checkCheckbox("filter.subscription.prefix.dailyWeeklyMonthly", "daysOfMonth");
        this.tester.submit("Subscribe");
    }

    @Test
    public void testMailNotConfiguredWarning() {
        this.addSubscription();
        this.navigation.manageFilters().goToDefault();
        this.navigation.manageFilters().manageSubscriptions(10000);
        this.textAssertions.assertTextPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Run now");
    }

    @Test
    public void testMailConfiguredNoWarning() {
        this.addSubscription();
        this.navigation.gotoDashboard();
        this.administration.mailServers().Smtp().goTo().add("testserver", "admin@example.com", "JIRA", "mail.example.com");
        this.navigation.manageFilters().goToDefault();
        this.navigation.manageFilters().manageSubscriptions(10000);
        this.textAssertions.assertTextNotPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
        this.textAssertions.assertTextPresent(this.locator.page(), "Run now");
    }

    @Test
    public void testNoMailServerNoSubscriptions() {
        this.navigation.manageFilters().goToDefault();
        this.textAssertions.assertTextNotPresent(this.locator.page(), NO_MAIL_SERVER_IS_CURRENTLY_CONFIGURED);
    }
}

