/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.edit;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.webtests.ztests.filter.edit.TestEditFilter;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

@LoginAs(user="admin")
@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestUserShareType
extends TestEditFilter {
    @Override
    String getRestoreDataXmlName() {
        return "sharedfilters/TestSharePermissionWithRights.xml";
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=712001)
    public void testCanAddUserShareTypeToFilter() {
        this.navigation.issueNavigator().editFilter(10030L);
        HashSet<SimpleTestSharingPermission> permissions = new HashSet<SimpleTestSharingPermission>();
        permissions.add(new SimpleTestSharingPermission("user", "editor_by_jira_developers_group", null, ShareRights.VIEW_EDIT));
        long id = this.editFilter(10030L, "new Name added by Admin", "new description added by Admin", false, permissions);
        Assert.assertEquals((long)id, (long)10030L);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=712001)
    public void testCannotAddShareTypeUserAsViewers() {
        this.navigation.issueNavigator().editFilter(10030L);
        HashSet<SimpleTestSharingPermission> permissions = new HashSet<SimpleTestSharingPermission>();
        permissions.add(new SimpleTestSharingPermission("user", "editor_by_jira_developers_group", null, ShareRights.VIEW));
        this.editFilterNoId(10030L, "new Name added by Admin", "new description added by Admin", false, permissions);
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "You can not give specified rights when sharing with User: 'editor_by_jira_developers_group'");
    }
}

