/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.management;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
@Restore(value="TestSharedFilterSearchingByAdmins.xml")
public class TestDeleteSharedFilterByAdmins
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testAnAdminIsAbleToDeleteFiltersSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10006L).name("Shared Filter With Group jira-developers owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().deleteFilter(10006L).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteFiltersSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10010L).name("Shared Filter with Anyone owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10009L).name("Shared Filter With group jira-administrators owned by admin").owner("Administrator").build(), (Object)new FilterItem.Builder().id(10002L).name("Shared Filter With Group jira-users owned by fred").owner("Fred Normal").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().deleteFilter(10010L).deleteFilter(10009L).deleteFilter(10002L).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteFiltersSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().deleteFilter(10004L).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }

    @Test
    public void testAnAdminIsAbleToDeleteFiltersSharedWithARoleHeIsPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10001L).name("Shared Filter With Role Users on homosapien owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10007L).name("Shared Filter With All Roles on monkey owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10005L).name("Shared Filter With Role Developers on monkey owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().deleteFilter(10005L).deleteFilter(10001L).deleteFilter(10007L).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToDeletePrivateFilters() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10000L).name("Private Filter Owned by fred").owner("Fred Normal").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().deleteFilter(10000L).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
    }
}

