/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ApplicationPropertiesControl;
import com.atlassian.jira.functest.framework.backdoor.PluginsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Strings;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
@LoginAs(user="admin")
public class TestI18nPluginLifecycle
extends BaseJiraFuncTest {
    private final String PLUGIN_OBR_URL = "https://packages.atlassian.com/maven-public/com/atlassian/jira/test/plugin/i18n.lifecycle/1.0.5/i18n.lifecycle-1.0.5.obr";
    private final String PLUGIN_KEY = "com.atlassian.jira.test.plugin.i18n.lifecycle";

    @Before
    public void before() throws Exception {
        this.installPlugin("https://packages.atlassian.com/maven-public/com/atlassian/jira/test/plugin/i18n.lifecycle/1.0.5/i18n.lifecycle-1.0.5.obr", "com.atlassian.jira.test.plugin.i18n.lifecycle");
    }

    @Test
    public void testI18nPluginLifecycle() throws Exception {
        MatcherAssert.assertThat((String)"unexpected key for onCreate", (Object)this.getTextFromApplicationProperty("onCreate"), (Matcher)IsEqual.equalTo((Object)"test.my.key"));
        this.waitForApplicationPropertyValue("onPluginEnabled");
        MatcherAssert.assertThat((String)"unresolved key for onPluginEnabled", (Object)this.getTextFromApplicationProperty("onPluginEnabled"), (Matcher)IsEqual.equalTo((Object)"Test My Key!"));
        this.waitForApplicationPropertyValue("onPluginEnabledInPluginTransactionEnd");
        MatcherAssert.assertThat((String)"unresolved key for onPluginEnabledInPluginTransactionEnd", (Object)this.getTextFromApplicationProperty("onPluginEnabledInPluginTransactionEnd"), (Matcher)IsEqual.equalTo((Object)"Test My Key!"));
        this.waitForApplicationPropertyValue("onPluginUpgrade");
        MatcherAssert.assertThat((String)"unresolved key for onPluginUpgrade", (Object)this.getTextFromApplicationProperty("onPluginUpgrade"), (Matcher)IsEqual.equalTo((Object)"Test My Key!"));
    }

    @After
    public void after() throws Exception {
        this.uninstallPlugin("com.atlassian.jira.test.plugin.i18n.lifecycle");
    }

    private String getTextFromApplicationProperty(String applicationPropertySuffix) {
        ApplicationPropertiesControl applicationPropertiesControl = this.getBackdoor().applicationProperties();
        return applicationPropertiesControl.getString("com.atlassian.jira.test.plugin.i18n.lifecycle." + applicationPropertySuffix);
    }

    private void waitForApplicationPropertyValue(String applicationPropertySuffix) {
        this.waitUntil("waiting for application property value: " + applicationPropertySuffix, () -> {
            String applicationProperty = this.getTextFromApplicationProperty(applicationPropertySuffix);
            return !Strings.isNullOrEmpty((String)applicationProperty);
        });
    }

    private void installPlugin(String pluginObrUrl, String pluginKey) throws MalformedURLException {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        plugins.uploadPlugin(new URL(pluginObrUrl));
        this.waitUntil("waiting for enabled plugin: " + pluginKey, () -> this.isPluginEnabled(pluginKey));
    }

    private void uninstallPlugin(String pluginKey) {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        plugins.unistallPlugin(pluginKey);
        MatcherAssert.assertThat((Object)plugins.getPlugin(pluginKey).isPresent(), (Matcher)Is.is((Object)false));
    }

    private boolean isPluginEnabled(String pluginKey) {
        PluginsControlExt plugins = this.getBackdoor().plugins();
        Optional<PluginsControlExt.PluginBean> optPlugin = plugins.getPlugin(pluginKey);
        return optPlugin.isPresent() && optPlugin.get().getEnabled() != false;
    }

    private void waitUntil(String waitingForDescription, Callable<Boolean> condition) {
        Awaitility.await((String)waitingForDescription).atMost(60L, TimeUnit.SECONDS).pollInterval(Duration.FIVE_HUNDRED_MILLISECONDS).until(condition);
    }
}

