/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexanalyzer;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.webtests.ztests.indexanalyzer.IndexAnalyzerClient;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING})
@LoginAs(user="admin")
public class TestIndexAnalyzer
extends BaseJiraFuncTest {
    private static final String PROJECT = "HSP";
    private static final String PROJECT2 = "MKY";
    private IndexAnalyzerClient client;
    private List<IssueCreateResponse> issues;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.client = new IndexAnalyzerClient(this.getEnvironmentData());
        this.issues = this.createIssues(4);
    }

    @Test
    public void testHappyPath() {
        AnalyzerResponse result = this.client.state();
        MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)this.issues.size()));
    }

    @Test
    public void testOrphanDB() {
        this.withDisabledIndexRepairService(() -> {
            IntStream.range(0, this.issues.size() / 2).forEach(i -> this.backdoor.indexing().deindex(this.issues.get(i).key()));
            AnalyzerResponse result = this.client.state();
            MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)(this.issues.size() / 2)));
            MatcherAssert.assertThat((Object)result.getDbOrphansCount(), (Matcher)IsEqual.equalTo((Object)(this.issues.size() / 2)));
        });
    }

    @Test
    public void testOutdatedIssues() {
        IntStream.range(0, this.issues.size() / 2).forEach(i -> this.backdoor.issueNavControl().changeUpdatedDateWithoutReindex(this.issues.get(i).key(), Instant.now().plusSeconds(10L)));
        AnalyzerResponse result = this.client.state();
        MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)(this.issues.size() / 2)));
        MatcherAssert.assertThat((Object)result.getOutdatedCount(), (Matcher)IsEqual.equalTo((Object)(this.issues.size() / 2)));
    }

    @Test
    public void testArchivedProjects() {
        this.createIssues(10, PROJECT2);
        this.backdoor.project().archiveProject(PROJECT2);
        AnalyzerResponse result = this.client.state();
        MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)this.issues.size()));
        MatcherAssert.assertThat((Object)result.getOutdatedCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getDbOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getIndexOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testArchivedIssues() {
        IntStream.range(0, this.issues.size() / 2).forEach(i -> this.backdoor.issues().archiveIssue(this.issues.get((int)i).key));
        AnalyzerResponse result = this.client.state();
        MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)(this.issues.size() / 2)));
        MatcherAssert.assertThat((Object)result.getOutdatedCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getDbOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getIndexOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testRestoredIssues() {
        IntStream.range(0, this.issues.size() / 2).forEach(i -> this.backdoor.issues().archiveIssue(this.issues.get((int)i).key));
        IntStream.range(0, this.issues.size() / 2).forEach(i -> this.backdoor.issues().restoreIssue(this.issues.get((int)i).key));
        AnalyzerResponse result = this.client.state();
        MatcherAssert.assertThat((Object)result.getOkCount(), (Matcher)IsEqual.equalTo((Object)this.issues.size()));
        MatcherAssert.assertThat((Object)result.getOutdatedCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getDbOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getIndexOrphansCount(), (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testAdminAccessOnlyForStateResource() {
        this.client.loginAs("fred", "fred");
        Response.StatusType status = this.client.stateClientResponseStatus();
        MatcherAssert.assertThat((Object)status, (Matcher)IsEqual.equalTo((Object)Response.Status.FORBIDDEN));
    }

    private List<IssueCreateResponse> createIssues(int count, String projectKey) {
        return IntStream.range(0, count).mapToObj(i -> this.backdoor.issues().createIssue(projectKey, "issue")).collect(Collectors.toList());
    }

    private List<IssueCreateResponse> createIssues(int count) {
        return this.createIssues(count, PROJECT);
    }

    private void withDisabledIndexRepairService(Runnable runnable) {
        try {
            this.backdoor.indexing().pauseIndexRepairService();
            runnable.run();
        }
        finally {
            this.backdoor.indexing().startIndexRepairService();
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AnalyzerResponse {
        private int okCount;
        private int outdatedCount;
        private int indexOrphansCount;
        private int dbOrphansCount;

        public int getOkCount() {
            return this.okCount;
        }

        public void setOkCount(int okCount) {
            this.okCount = okCount;
        }

        public int getOutdatedCount() {
            return this.outdatedCount;
        }

        public void setOutdatedCount(int outdatedCount) {
            this.outdatedCount = outdatedCount;
        }

        public int getIndexOrphansCount() {
            return this.indexOrphansCount;
        }

        public void setIndexOrphansCount(int indexOrphansCount) {
            this.indexOrphansCount = indexOrphansCount;
        }

        public int getDbOrphansCount() {
            return this.dbOrphansCount;
        }

        public void setDbOrphansCount(int dbOrphansCount) {
            this.dbOrphansCount = dbOrphansCount;
        }
    }
}

