/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexanalyzer;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.webtests.ztests.indexanalyzer.IndexAnalyzerClient;
import com.atlassian.jira.webtests.ztests.indexanalyzer.TestIndexAnalyzer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING})
@LoginAs(user="admin")
public class TestIndexHealer
extends BaseJiraFuncTest {
    private static final long PROJECT_HOMOSAP_ID = 10000L;
    private IndexAnalyzerClient client;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.client = new IndexAnalyzerClient(this.getEnvironmentData());
    }

    @Test
    public void testHealer() {
        this.withDisabledIndexRepairService(() -> {
            IssueCreateResponse issueDbOrphan0 = this.createIssue(0);
            IssueCreateResponse issueDbOrphan1 = this.createIssue(1);
            this.backdoor.indexing().deindex(issueDbOrphan0.key());
            this.backdoor.indexing().deindex(issueDbOrphan1.key());
            IssueCreateResponse issueOutdated2 = this.createIssue(2);
            IssueCreateResponse issueOutdated3 = this.createIssue(3);
            Instant futureDate = Instant.from(LocalDate.of(2150, 4, 9).atStartOfDay(ZoneId.systemDefault()));
            this.backdoor.issueNavControl().changeUpdatedDateWithoutReindex(issueOutdated2.key(), futureDate);
            this.backdoor.issueNavControl().changeUpdatedDateWithoutReindex(issueOutdated3.key(), futureDate);
            IssueCreateResponse issueUpToDate4 = this.createIssue(4);
            IssueCreateResponse issueUpToDate5 = this.createIssue(5);
            IssueCreateResponse issueIndexOrphan6 = this.createIndexOrphan(6);
            IssueCreateResponse issueIndexOrphan7 = this.createIndexOrphan(7);
            Assertions.assertThat(this.getAllSearchableIssues()).containsExactlyInAnyOrder((Object[])new String[]{issueOutdated2.key(), issueOutdated3.key(), issueUpToDate4.key(), issueUpToDate5.key(), issueIndexOrphan6.key(), issueIndexOrphan7.key()});
            Assertions.assertThat(this.getIssuesAfterDaleksInvasionOnEarth()).isEmpty();
            HealResponse healResult = this.client.heal();
            HealerResponse healerResult = healResult.getHealerResult();
            TestIndexAnalyzer.AnalyzerResponse analyzeAfterResult = healResult.getAnalyzeAfterResult();
            Assertions.assertThat((int)analyzeAfterResult.getDbOrphansCount()).isEqualTo(0);
            Assertions.assertThat((int)analyzeAfterResult.getOutdatedCount()).isEqualTo(0);
            Assertions.assertThat((int)analyzeAfterResult.getIndexOrphansCount()).isEqualTo(0);
            Assertions.assertThat((int)healerResult.getReindexedDbOrphansSuccessful().getCount()).isEqualTo(2);
            Assertions.assertThat(healerResult.getReindexedDbOrphansSuccessful().getIds()).containsExactlyInAnyOrder((Object[])new Long[]{Long.parseLong(issueDbOrphan0.id()), Long.parseLong(issueDbOrphan1.id())});
            Assertions.assertThat((int)healerResult.getReindexedOutdatedIssuesSuccessful().getCount()).isEqualTo(2);
            Assertions.assertThat(healerResult.getReindexedOutdatedIssuesSuccessful().getIds()).containsExactlyInAnyOrder((Object[])new Long[]{Long.parseLong(issueOutdated2.id()), Long.parseLong(issueOutdated3.id())});
            Assertions.assertThat((int)healerResult.getDeindexedIndexOrphansSuccessful().getCount()).isEqualTo(2);
            Assertions.assertThat(healerResult.getDeindexedIndexOrphansSuccessful().getIds()).containsExactlyInAnyOrder((Object[])new Long[]{Long.parseLong(issueIndexOrphan6.id()), Long.parseLong(issueIndexOrphan7.id())});
            Assertions.assertThat((int)healerResult.getReindexedDbOrphansFailed().getCount()).isEqualTo(0);
            Assertions.assertThat(healerResult.getReindexedDbOrphansFailed().getIds()).isEmpty();
            Assertions.assertThat((int)healerResult.getReindexedOutdatedIssuesFailed().getCount()).isEqualTo(0);
            Assertions.assertThat(healerResult.getReindexedOutdatedIssuesFailed().getIds()).isEmpty();
            Assertions.assertThat((int)healerResult.getDeindexedIndexOrphansFailed().getCount()).isEqualTo(0);
            Assertions.assertThat(healerResult.getDeindexedIndexOrphansFailed().getIds()).isEmpty();
            Assertions.assertThat(this.getAllSearchableIssues()).containsExactlyInAnyOrder((Object[])new String[]{issueDbOrphan0.key(), issueDbOrphan1.key(), issueOutdated2.key(), issueOutdated3.key(), issueUpToDate4.key(), issueUpToDate5.key()});
            Assertions.assertThat(this.getIssuesAfterDaleksInvasionOnEarth()).containsExactlyInAnyOrder((Object[])new String[]{issueOutdated2.key(), issueOutdated3.key()});
        });
    }

    private List<String> getAllSearchableIssues() {
        return this.search("");
    }

    private List<String> getIssuesAfterDaleksInvasionOnEarth() {
        return this.search("updated > 2150-01-01");
    }

    private List<String> search(String jql) {
        return this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)jql)).issues.stream().map(i -> i.key).collect(Collectors.toList());
    }

    private IssueCreateResponse createIssue(int issueId) {
        return this.backdoor.issues().createIssue("HSP", "summary" + issueId);
    }

    private IssueCreateResponse createIndexOrphan(int issueId) {
        String issueKey = "HSP-" + issueId;
        this.backdoor.indexing().indexDummyIssue(issueId, 10000L, "Task", issueKey, "summary" + issueId, "");
        IssueCreateResponse issueCreateResponse = new IssueCreateResponse();
        issueCreateResponse.id = Integer.toString(issueId);
        issueCreateResponse.key = issueKey;
        return issueCreateResponse;
    }

    private void withDisabledIndexRepairService(Runnable runnable) {
        try {
            this.backdoor.indexing().pauseIndexRepairService();
            runnable.run();
        }
        finally {
            this.backdoor.indexing().startIndexRepairService();
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class HealResponse {
        private HealerResponse healerResult;
        private TestIndexAnalyzer.AnalyzerResponse analyzeAfterResult;

        public HealerResponse getHealerResult() {
            return this.healerResult;
        }

        public void setHealerResult(HealerResponse healerResult) {
            this.healerResult = healerResult;
        }

        public TestIndexAnalyzer.AnalyzerResponse getAnalyzeAfterResult() {
            return this.analyzeAfterResult;
        }

        public void setAnalyzeAfterResult(TestIndexAnalyzer.AnalyzerResponse analyzeAfterResult) {
            this.analyzeAfterResult = analyzeAfterResult;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class HealerResponse {
        private ListWithSize reindexedDbOrphansSuccessful;
        private ListWithSize reindexedDbOrphansFailed;
        private ListWithSize reindexedOutdatedIssuesSuccessful;
        private ListWithSize reindexedOutdatedIssuesFailed;
        private ListWithSize deindexedIndexOrphansSuccessful;
        private ListWithSize deindexedIndexOrphansFailed;

        public ListWithSize getReindexedDbOrphansSuccessful() {
            return this.reindexedDbOrphansSuccessful;
        }

        public void setReindexedDbOrphansSuccessful(ListWithSize reindexedDbOrphansSuccessful) {
            this.reindexedDbOrphansSuccessful = reindexedDbOrphansSuccessful;
        }

        public ListWithSize getReindexedDbOrphansFailed() {
            return this.reindexedDbOrphansFailed;
        }

        public void setReindexedDbOrphansFailed(ListWithSize reindexedDbOrphansFailed) {
            this.reindexedDbOrphansFailed = reindexedDbOrphansFailed;
        }

        public ListWithSize getReindexedOutdatedIssuesSuccessful() {
            return this.reindexedOutdatedIssuesSuccessful;
        }

        public void setReindexedOutdatedIssuesSuccessful(ListWithSize reindexedOutdatedIssuesSuccessful) {
            this.reindexedOutdatedIssuesSuccessful = reindexedOutdatedIssuesSuccessful;
        }

        public ListWithSize getReindexedOutdatedIssuesFailed() {
            return this.reindexedOutdatedIssuesFailed;
        }

        public void setReindexedOutdatedIssuesFailed(ListWithSize reindexedOutdatedIssuesFailed) {
            this.reindexedOutdatedIssuesFailed = reindexedOutdatedIssuesFailed;
        }

        public ListWithSize getDeindexedIndexOrphansSuccessful() {
            return this.deindexedIndexOrphansSuccessful;
        }

        public void setDeindexedIndexOrphansSuccessful(ListWithSize deindexedIndexOrphansSuccessful) {
            this.deindexedIndexOrphansSuccessful = deindexedIndexOrphansSuccessful;
        }

        public ListWithSize getDeindexedIndexOrphansFailed() {
            return this.deindexedIndexOrphansFailed;
        }

        public void setDeindexedIndexOrphansFailed(ListWithSize deindexedIndexOrphansFailed) {
            this.deindexedIndexOrphansFailed = deindexedIndexOrphansFailed;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListWithSize {
        private int count;
        private List<Long> ids;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }
    }
}

