/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EntityVersioningControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.OptionalMatchers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING, Category.PERFORMANCE})
@RestoreBlankInstance
public class TestEntityVersioningThreadSafety
extends BaseJiraFuncTest {
    private EntityVersioningControl entityVersioningControl;
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        this.entityVersioningControl = this.backdoor.entityVersioningControl();
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Ignore(value="This test takes ~60s to run; use it locally as needed (DBR-64)")
    @Test
    public void testConcurrentIncrementsToEnsureThreadSafety() throws Exception {
        int concurrencyLevel = 100;
        int incrementsPerThread = 10;
        int entitiesCount = 50;
        this.testConcurrentIncrementsToEnsureThreadSafety(100, 10, 50);
    }

    @Test
    public void testConcurrentIncrementsToEnsureThreadSafetyInCI() throws Exception {
        int concurrencyLevel = 100;
        int incrementsPerThread = 10;
        int entitiesCount = 10;
        this.testConcurrentIncrementsToEnsureThreadSafety(100, 10, 10);
    }

    private void testConcurrentIncrementsToEnsureThreadSafety(int concurrencyLevel, int incrementsPerThread, int entitiesCount) throws Exception {
        long expectedFinalVersion = concurrencyLevel * incrementsPerThread;
        CyclicBarrier startAtOnce = new CyclicBarrier(concurrencyLevel);
        List entities = LongStream.range(0L, entitiesCount).boxed().collect(Collectors.toList());
        this.executorService = Executors.newFixedThreadPool(concurrencyLevel);
        Assert.assertThat(this.entityVersioningControl.getAllIssueVersions(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        ArrayList<Future<Void>> jobDoneAcknowledgements = new ArrayList<Future<Void>>(concurrencyLevel);
        for (int thread = 0; thread < concurrencyLevel; ++thread) {
            jobDoneAcknowledgements.add(this.executorService.submit(() -> {
                startAtOnce.await();
                for (int i = 0; i < incrementsPerThread; ++i) {
                    for (Long entity : entities) {
                        this.entityVersioningControl.incrementIssueVersion(entity);
                    }
                }
                return null;
            }));
        }
        for (Future future : jobDoneAcknowledgements) {
            future.get();
        }
        for (Long l : entities) {
            Assert.assertThat(this.entityVersioningControl.getIssueVersion(l), (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)expectedFinalVersion)));
        }
    }
}

