/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AssertRedirect;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.beans.Priority;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestCreateIssue
extends BaseJiraFuncTest {
    private static final String PROJECT_MONKEY_ID = "10001";
    private static final String PERMISSION_ERROR = "You do not have permission to create issues in this project.";
    @Inject
    private AssertRedirect assertRedirect;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Indexing indexing;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
    }

    @Test
    public void testCreateIssueInJiraWithMultipleProjectsAndManyIssueTypes() {
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("Create Issue");
        this.tester.assertTextNotPresent("CreateIssueDetails.jspa");
        this.tester.assertFormElementPresent("pid");
        this.tester.assertFormElementPresent("issuetype");
        this.tester.assertFormElementNotPresent("summary");
    }

    @Test
    @Restore(value="TestOneProjectWithOneIssueType.xml")
    public void testCreateIssueInJiraWithSingleProjectAndSingleIssueType() {
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Project", "homosapien", "Issue Type", "Bug"});
        this.tester.assertFormElementPresent("summary");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugs & Sub-tasks");
        this.tester.submit();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Project", "homosapien", "Issue Type", "Bug"});
        this.tester.assertFormElementPresent("summary");
    }

    @Test
    public void testCreateIssue() {
        this.editIssueFieldVisibility.resetFields();
        String issueKey1 = this.createIssue();
        String issueKey2 = this.createIssueWithoutComponents();
        String issueKey3 = this.createIssueWithTimeTrackingDetails();
        String issueKey4 = this.createIssueWithoutAssignee();
        this.createIssueWithNoSummary();
        this.createIssueWithRequiredFields();
        this.createIssueWithHiddenFields();
        this.createIssueWithInvalidDueDate();
        this.createIssueWithCreatePermission();
        this.createIssueWithSchedulePermission();
        this.createIssueWithAssignPermission();
        this.createIssueWithModifyReporterPermission();
        this.createIssueWithTimeTracking();
        this.createIssueWithUnassignableUser();
        this.deleteCreatedIssue(issueKey1);
        this.deleteCreatedIssue(issueKey2);
        this.deleteCreatedIssue(issueKey3);
        this.deleteCreatedIssue(issueKey4);
    }

    @Test
    public void testCreateIssueSkipStep1OnlyOneProjectAndOneIssueType() {
        String[] data;
        for (String dataBackup : data = new String[]{"TestCreateIssueOneProjectOneIssueType.xml", "TestCreateIssueOneIssueCreateProjectOneIssueType.xml"}) {
            this.navigation.gotoDashboard();
            this.administration.restoreData(dataBackup);
            this.assertRedirect.assertRedirectAndFollow("/secure/CreateIssue!default.jspa", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Task", "Summary"});
        }
    }

    @Test
    @Restore(value="TestCreateIssueOneProjectOneIssueType.xml")
    @LoginAs(user="fred")
    public void testCreateIssueUserHasNoCreateIssuePermission() {
        this.tester.assertLinkNotPresent("create_link");
        this.navigation.browseProject("MKY");
        this.tester.assertLinkNotPresentWithText("Create a new issue in project monkey");
        this.tester.gotoPage("/secure/CreateIssue!default.jspa?pid=10001");
        this.tester.assertTextPresent("Error");
        this.tester.assertTextPresent(PERMISSION_ERROR);
        this.tester.gotoPage("/secure/CreateIssue!default.jspa");
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), PERMISSION_ERROR);
    }

    @Test
    @Restore(value="TestCreateIssueOneProjectThreeIssueTypes.xml")
    public void testCreateIssueWithNoPidInUrlOneProjectAvailableIssueTypeInUrl() {
        this.tester.clickLink("create_link");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Issue"});
        String monkeyTask = ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$";
        this.assertRedirect.assertRedirectAndFollow("/secure/CreateIssue!default.jspa?issuetype=3", ".*CreateIssue\\.jspa\\?pid=10001&issuetype=3$");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Issue", "CreateIssueDetails.jspa", "Project", "monkey", "Issue Type", "Task", "Summary"});
    }

    private void deleteCreatedIssue(String issueKey) {
        this.navigation.issue().deleteIssue(issueKey);
        this.assertPageDoesNotExist("The issue has not been removed from the index.", "/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
    }

    public String createIssue() {
        String versionOneId = this.getVersionMap().get((Object)"New Version 1").id.toString();
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "test 1", (Map<String, String[]>)ImmutableMap.of((Object)"components", (Object)new String[]{this.getComponentMap().get((Object)"New Component 1").id.toString()}, (Object)"versions", (Object)new String[]{versionOneId}, (Object)"fixVersions", (Object)new String[]{versionOneId}, (Object)"priority", (Object)new String[]{this.getPriorityMap().get("Minor").getId()}, (Object)"assignee", (Object)new String[]{"admin"}));
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertTextPresent("test 1");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("Minor");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"summary", (Object)"test 1"), null, issueKey);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)issueKey), null, issueKey);
        return issueKey;
    }

    public String createIssueWithoutComponents() {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Improvement", "test 2", (Map<String, String[]>)ImmutableMap.of((Object)"priority", (Object)new String[]{this.getPriorityMap().get("Major").getId()}, (Object)"assignee", (Object)new String[]{"admin"}));
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertTextPresent("test 2");
        this.tester.assertTextPresent("Improvement");
        this.tester.assertTextPresent("Major");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)"Improvement"), null, issueKey);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"summary", (Object)"test 2"), null, issueKey);
        return issueKey;
    }

    public String createIssueWithTimeTrackingDetails() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.navigation.issue().createIssue("homosapien", "New Feature", "test 3", (Map<String, String[]>)ImmutableMap.of((Object)"priority", (Object)new String[]{this.getPriorityMap().get("Critical").getId()}, (Object)"assignee", (Object)new String[]{"admin"}, (Object)"timetracking", (Object)new String[]{"1w"}));
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertTextPresent("test 3");
        this.tester.assertTextPresent("New Feature");
        this.tester.assertTextPresent("Critical");
        this.tester.assertTextPresent("Original Estimate");
        this.tester.assertTextPresent("1 week");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"priority", (Object)"Critical"), null, issueKey);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)"New Feature"), null, issueKey);
        this.administration.timeTracking().disable();
        return issueKey;
    }

    public String createIssueWithoutAssignee() {
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Task", "test 4", (Map<String, String[]>)ImmutableMap.of((Object)"components", (Object)new String[]{this.getComponentMap().get((Object)"New Component 1").id.toString()}, (Object)"priority", (Object)new String[]{this.getPriorityMap().get("Blocker").getId()}, (Object)"assignee", (Object)new String[]{null}, (Object)"environment", (Object)new String[]{"test environment 4"}));
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertTextPresent("test 4");
        this.tester.assertTextPresent("Task");
        this.tester.assertTextPresent("Blocker");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "Unassigned");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"priority", (Object)"Blocker"), null, issueKey);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"environment", (Object)"test environment 4"), null, issueKey);
        this.navigation.issue().assignIssue(issueKey, "Assigning issue to ADMIN", "Administrator");
        this.administration.generalConfiguration().setAllowUnassignedIssues(false);
        return issueKey;
    }

    public void createIssueWithNoSummary() {
        this.logger.log((Object)"Create Issue: Adding issue without summary");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.selectOption("priority", "Minor");
        this.tester.submit();
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("You must specify a summary of the issue.");
    }

    public void createIssueWithRequiredFields() {
        this.editIssueFieldVisibility.setRequiredFields();
        this.logger.log((Object)"Create Issue: Test the creation of an issue using required fields");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "This is a new summary");
        this.tester.setFormElement("reporter", "");
        this.tester.submit("Create");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.editIssueFieldVisibility.resetFields();
    }

    public void createIssueWithHiddenFields() {
        this.editIssueFieldVisibility.setHiddenFields("Component/s");
        this.editIssueFieldVisibility.setHiddenFields("Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFields("Fix Version/s");
        this.logger.log((Object)"Create Issue: Test the creation of am issue using hidden fields");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("components");
        this.tester.assertFormElementNotPresent("versions");
        this.tester.assertFormElementNotPresent("fixVersions");
        this.editIssueFieldVisibility.resetFields();
    }

    public void createIssueWithInvalidDueDate() {
        this.logger.log((Object)"Create Issue: Adding issue with invalid due date");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.setFormElement("summary", "stuff");
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit("Create");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
    }

    public void createIssueWithCreatePermission() {
        this.logger.log((Object)"Create Issue: Test availability of 'Create Issue' link with 'Create Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.gotoDashboard();
        this.tester.assertLinkNotPresent("create_link");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
    }

    public void createIssueWithSchedulePermission() {
        this.logger.log((Object)"Create Issue: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertTextNotPresent("Due Date");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertTextPresent("Due Date");
    }

    public void createIssueWithAssignPermission() {
        this.logger.log((Object)"Create Issue: Test ability to specify assignee with 'Assign Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("assignee");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementPresent("assignee");
    }

    public void createIssueWithModifyReporterPermission() {
        this.logger.log((Object)"Create Issue: Test availability of Reporter with 'Modify Reporter' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("reporter");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementPresent("reporter");
    }

    public void createIssueWithTimeTracking() {
        this.logger.log((Object)"Create Issue: Test availability of time tracking ...");
        this.administration.timeTracking().disable();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementNotPresent("timetracking");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.assertFormElementPresent("timetracking");
        this.administration.timeTracking().disable();
    }

    public void createIssueWithUnassignableUser() {
        this.logger.log((Object)"Create Issue: Attempt to set the assignee to be an unassignable user ...");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.submit("Create");
        this.tester.setFormElement("summary", "Test summary");
        this.tester.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
    }

    @Test
    public void testEscapeProjectNameOnFirstScreenOfCreateIssue() {
        this.backdoor.project().addProject("Xss PRoject &trade;", "XP", "admin");
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.tester.assertTextNotPresent("&trade;");
        this.tester.assertTextPresent("&amp;trade;");
    }

    @Test
    public void testXssInDueDate() {
        String value = "\"><script>";
        String valueEncoded = "&quot;&gt;&lt;script&gt;";
        String expectedFormElement = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"";
        String notExpected = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"\"><script>\"";
        String expected = "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"&quot;&gt;&lt;script&gt;\"";
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("duedate", "\"><script>");
        this.tester.submit("Create");
        this.textAssertions.assertTextPresent(this.locator.page().getHTML(), "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"&quot;&gt;&lt;script&gt;\"");
        this.textAssertions.assertTextNotPresent(this.locator.page().getHTML(), "<input class=\"text medium-field\" id=\"duedate\" name=\"duedate\" type=\"text\" value=\"\"><script>\"");
    }

    @Test
    public void testCreateButtonEncoding() {
        String issueTypeBugFrench = this.backdoor.i18n().getText("jira.translation.issuetype.bug.name", "fr_FR");
        String createIssueFrench = this.backdoor.i18n().getText("common.words.create", "fr_FR");
        try {
            this.navigation.userProfile().changeUserLanguage("fran\u00e7ais (France)");
            this.navigation.issue().goToCreateIssueForm("homosapien", issueTypeBugFrench);
            this.assertions.assertNodeHasText(this.locator.xpath("//button[@id='issue-create-submit']/@value"), createIssueFrench);
        }
        finally {
            this.navigation.userProfile().changeUserLanguageToJiraDefault();
        }
    }

    private void assertPageDoesNotExist(String assertionMessage, String url) {
        this.logger.log((Object)("asserting that the page does not exist. [" + url + "]"));
        this.tester.gotoPage(url);
        if (this.tester.getDialog().getResponse().getResponseCode() == HttpStatus.OK.code) {
            Assert.fail((String)assertionMessage);
        }
    }

    private Map<String, Priority> getPriorityMap() {
        return this.backdoor.getTestkit().priorities().getPriorities().stream().collect(Collectors.toMap(Priority::getName, Function.identity()));
    }

    private Map<String, Version> getVersionMap() {
        return this.backdoor.project().getVersionsForProject("HSP").stream().collect(Collectors.toMap(v -> v.name, Function.identity()));
    }

    private Map<String, Component> getComponentMap() {
        return this.backdoor.project().getComponentsForProject("HSP").stream().collect(Collectors.toMap(v -> v.name, Function.identity()));
    }
}

