/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@Restore(value="TestCantViewCreatedIssue.xml")
public class TestCreateIssueNoBrowseProjectPermission
extends BaseJiraFuncTest {
    private static final String LOGIN = "log in";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
    }

    @Test
    public void testCreateIssueWithNoBrowsePermission() {
        this.logger.log((Object)"Create Issue: Adding issue with no browse permission for user");
        this.administration.restoreData("TestCantViewCreatedIssue.xml");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issue().createIssue("noBrowseProject", "Bug", "test1");
        this.assertIssueCreatedButCannotView(false);
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "nobrowseuser");
        this.tester.setFormElement("os_password", "nobrowseuser");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertIssueCreatedButCannotView(true);
        this.navigation.issue().createIssue("noBrowseProject", "Bug", "test1");
        this.assertIssueCreatedButCannotView(true);
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issue().createIssue("noBrowseProject", "Bug", "test1");
        this.assertIssueCreatedButCannotView(false);
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.tester.assertTextNotPresent("Issue Created Successfully");
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertTextPresent("Details");
        this.administration.restoreBlankInstance();
    }

    private void assertIssueCreatedButCannotView(boolean loggedIn) {
        this.tester.assertTextPresent("Issue Created Successfully");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "You have successfully created the issue (", "), however you do not have the permission to view the created issue.");
        if (!loggedIn) {
            this.tester.assertLinkPresentWithText(LOGIN);
        }
    }
}

