/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@Restore(value="TestEditIssueVersion.xml")
public class TestEditIssueFields
extends BaseJiraFuncTest {
    @Inject
    Assertions assertions;

    @Before
    public void setUpTest() {
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testNoneDisplayedGivenNoAvailableVersions() {
        this.navigation.issue().gotoEditIssue("MK-1");
        this.assertions.assertNodeHasText(this.versionPickerLocatorFor("versions"), "None");
        this.assertions.assertNodeDoesNotHaveText(this.versionPickerLocatorFor("versions"), "Unknown");
        this.assertions.assertNodeHasText(this.versionPickerLocatorFor("fixVersions"), "None");
        this.assertions.assertNodeDoesNotHaveText(this.versionPickerLocatorFor("fixVersions"), "Unknown");
    }

    @Test
    public void testNoneDisplayedGivenNoAvailableComponents() {
        this.navigation.issue().gotoEditIssue("MK-1");
        this.assertions.assertNodeHasText(this.componentPickerLocator(), "None");
        this.assertions.assertNodeDoesNotHaveText(this.componentPickerLocator(), "Unknown");
    }

    private String versionPickerLocatorFor(String versionPickerFieldId) {
        return String.format("//div[contains(@class, 'field-group') and contains(@class, 'aui-field-versionspicker')]/label[@for='%s']/..", versionPickerFieldId);
    }

    private String componentPickerLocator() {
        return "//div[contains(@class, 'field-group') and contains(@class, 'aui-field-componentspicker')]";
    }
}

