/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.RegexMatchers;
import java.io.IOException;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@Restore(value="TestIssueConstants.xml")
public class TestIssueConstants
extends BaseJiraFuncTest {
    private static final String INVALID_ELEMENT_NAME = "wrong";
    private static final String SUFFIX_HTML = " </td><td><input name=&quot;wrong&quot;>";
    private static final String SUFFIX_TEXT = " </td><td><input name=\"wrong\">";
    private static final String SUFFIX_ESC = " &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String SUFFIX_JSON_ESC = " &lt;/td&gt;&lt;td&gt;&lt;input name=\\&quot;wrong\\&quot;&gt;";
    private static final String NAME_PREFIX = "name ";
    private static final String DESC_PREFIX = "desc ";
    private static final String ISSUE_TYPE_HTML_OPTION = "name type </td><td><input name=\"wrong\">";
    private static final String ISSUE_TYPE_NAME_HTML = "name type </td><td><input name=&quot;wrong&quot;>";
    private static final String ISSUE_TYPE_DESC_HTML = "desc type </td><td><input name=&quot;wrong&quot;>";
    private static final String ISSUE_TYPE_NAME_HTML_ESC = "name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String ISSUE_TYPE_NAME_JSON_ESC = "name type &lt;/td&gt;&lt;td&gt;&lt;input name=\\&quot;wrong\\&quot;&gt;";
    private static final String ISSUE_TYPE_DESC_HTML_ESC = "desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String ISSUE_TYPE_NAME_TEXT = "New Feature";
    private static final String SUBTASK_TYPE_NAME_HTML = "name subtype </td><td><input name=&quot;wrong&quot;>";
    private static final String SUBTASK_TYPE_DESC_HTML = "desc subtype </td><td><input name=&quot;wrong&quot;>";
    private static final String SUBTASK_TYPE_NAME_HTML_ESC = "name subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String SUBTASK_TYPE_DESC_HTML_ESC = "desc subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_HTML_OPTION = "name priority </td><td><input name=\"wrong\">";
    private static final String PRIORITY_NAME_HTML = "name priority </td><td><input name=&quot;wrong&quot;>";
    private static final String PRIORITY_DESC_HTML = "desc priority </td><td><input name=&quot;wrong&quot;>";
    private static final String PRIORITY_NAME_HTML_ESC = "name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_DESC_HTML_ESC = "desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_NAME_TEXT = "Major";
    private static final String RESOLUTION_NAME_HTML_ESC = "name resolution &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String RESOLUTION_DESC_HTML_ESC = "desc resolution &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String STATUS_NAME_HTML = "name status </td><td><input name=&quot;wrong&quot;>";
    private static final String STATUS_DESC_HTML = "desc status </td><td><input name=&quot;wrong&quot;>";
    private static final String STATUS_NAME_HTML_ESC = "name status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String STATUS_DESC_HTML_ESC = "desc status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String STATUS_NAME_TEXT = "In Progress";
    private static final String RESOLVED_STATUS_NAME_HTML = "name resolved </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLVED_STATUS_DESC_HTML = "desc resolved </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLVED_STATUS_NAME_HTML_ESC = "name resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String RESOLVED_STATUS_DESC_HTML_ESC = "desc resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String TRANSLATED_BUG_NAME = "French_Bug";
    private static final String TRANSLATED_BUG_DESCRIPTION = "French_Desc";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.navigation.login("admin");
    }

    @Test
    public void testIssueConstantsAreEncodedOnReports() {
        this.navigation.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.tester.selectOption("mapper", "Issue Type");
        this.tester.setFormElement("filterid", "10002");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
    }

    @Test
    public void testIssueConstantsAreEncodedOnBulkOperation() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.selectIssuesForBulkOperation();
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.tester.checkCheckbox("actions", "issuetype");
        this.navigation.issue().selectIssueType(ISSUE_TYPE_HTML_OPTION, "issuetype");
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", PRIORITY_HTML_OPTION);
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.selectIssuesForBulkOperation();
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.selectIssuesForBulkOperation();
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "jira_4_3");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.tester.assertTextNotPresent(STATUS_NAME_HTML);
        this.tester.assertTextPresent(STATUS_NAME_HTML_ESC);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.selectIssuesForBulkOperation();
        this.tester.checkCheckbox("operation", "bulk.delete.operation.name");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
    }

    @Test
    public void testIssueConstantsAreEncodedOnViewIssue() {
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
        this.tester.assertTextPresent("title=\"name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.tester.assertTextPresent("title=\"name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertDropdownPresent(this.makeTruncatedDropdownText(RESOLVED_STATUS_NAME_HTML_ESC));
        this.tester.assertTextPresent(RESOLUTION_NAME_HTML_ESC);
        this.tester.assertTextPresent(SUBTASK_TYPE_NAME_HTML_ESC);
        this.navigation.issue().viewIssue("HSP-4");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.tester.assertTextNotPresent(SUBTASK_TYPE_NAME_HTML);
        this.tester.assertTextNotPresent(PRIORITY_NAME_HTML);
        this.tester.assertTextNotPresent(RESOLVED_STATUS_NAME_HTML);
        this.tester.assertTextNotPresent(SUBTASK_TYPE_DESC_HTML);
        this.tester.assertTextNotPresent(PRIORITY_DESC_HTML);
        this.tester.assertTextNotPresent(RESOLVED_STATUS_DESC_HTML);
        this.tester.assertTextPresent("title=\"name subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.tester.assertTextPresent("title=\"name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertDropdownPresent(this.makeTruncatedDropdownText(STATUS_NAME_HTML_ESC));
        this.navigation.issue().viewPrintable("HSP-3");
        this.assertIssueConstantHTMLContentViewPresent();
        this.textAssertions.assertTextSequence(this.locator.page().getHTML(), "Resolution:", RESOLUTION_NAME_HTML_ESC);
        this.tester.assertFormNotPresent();
        this.navigation.issue().viewXml("HSP-3");
        this.assertIssueConstantHTMLPresentInXML();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "<status id=\"5\"", ">", RESOLVED_STATUS_NAME_HTML_ESC, "</status>");
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.clickLinkWithText("Word");
        this.assertIssueConstantHTMLContentViewPresent();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Resolution:", RESOLUTION_NAME_HTML_ESC);
    }

    private void assertLozengePresent(String lozengeContent) {
        MatcherAssert.assertThat((Object)this.tester.getDialog().getResponseText(), (Matcher)RegexMatchers.regexMatches((String)("<span(.*)class=\"(.*)aui-lozenge(.*)\"(.*)>" + lozengeContent + "</span>")));
    }

    private void assertDropdownPresent(String dropdownContent) {
        MatcherAssert.assertThat((Object)this.tester.getDialog().getResponseText(), (Matcher)RegexMatchers.regexMatches((String)("<span(.*)class=\"(.*)dropdown-text(.*)\"(.*)>" + dropdownContent + "</span>")));
    }

    private String makeTruncatedDropdownText(String text) {
        if (text.length() > 25) {
            return text.substring(0, 22) + "...";
        }
        return text;
    }

    @Test
    public void testIssueConstantsAreEncodedOnAdminPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        String issueTypesHTML = this.locator.page().getHTML();
        this.textAssertions.assertTextSequence(issueTypesHTML, ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.textAssertions.assertTextSequence(issueTypesHTML, SUBTASK_TYPE_NAME_HTML_ESC, SUBTASK_TYPE_DESC_HTML_ESC);
        this.navigation.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=issuetype");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        String issueTypesTranslationsHTML = this.locator.page().getHTML();
        this.textAssertions.assertTextSequence(issueTypesTranslationsHTML, ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PRIORITIES);
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        String prioritiesHTML = this.locator.page().getHTML();
        this.textAssertions.assertTextSequence(prioritiesHTML, PRIORITY_NAME_HTML_ESC, PRIORITY_DESC_HTML_ESC);
        this.navigation.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=priority");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.textAssertions.assertTextSequence(prioritiesHTML, PRIORITY_NAME_HTML_ESC, PRIORITY_DESC_HTML_ESC);
        this.navigation.gotoAdminSection(Navigation.AdminSection.RESOLUTIONS);
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        String resolutionsHTML = this.locator.page().getHTML();
        this.textAssertions.assertTextSequence(resolutionsHTML, RESOLUTION_NAME_HTML_ESC, RESOLUTION_DESC_HTML_ESC);
        this.navigation.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=resolution");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.textAssertions.assertTextSequence(resolutionsHTML, RESOLUTION_NAME_HTML_ESC, RESOLUTION_DESC_HTML_ESC);
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        String statusesHTML = this.locator.page().getHTML();
        this.textAssertions.assertTextSequence(statusesHTML, STATUS_NAME_HTML_ESC, STATUS_DESC_HTML_ESC);
        this.textAssertions.assertTextSequence(statusesHTML, RESOLVED_STATUS_NAME_HTML_ESC, RESOLVED_STATUS_DESC_HTML_ESC);
        this.navigation.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=status");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.textAssertions.assertTextSequence(statusesHTML, STATUS_NAME_HTML_ESC, STATUS_DESC_HTML_ESC);
        this.textAssertions.assertTextSequence(statusesHTML, RESOLVED_STATUS_NAME_HTML_ESC, RESOLVED_STATUS_DESC_HTML_ESC);
    }

    @Test
    public void testIssueConstantsAreEncodedOnEditIssue() {
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.tester.assertTextPresent(ISSUE_TYPE_NAME_JSON_ESC);
        this.tester.assertTextPresent(ISSUE_TYPE_NAME_TEXT);
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.navigation.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=4");
        this.tester.submit("Delete");
        this.navigation.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=3");
        this.tester.submit("Delete");
        this.navigation.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=2");
        this.tester.submit("Delete");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.textAssertions.assertTextSequence(this.locator.page().getHTML(), ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.tester.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.tester.assertTextNotPresent(ISSUE_TYPE_NAME_TEXT);
        this.tester.assertTextPresent("There are no issue types with compatible field configuration and/or workflow associations.");
    }

    @Test
    public void testIssueConstantsAreTranslated() throws IOException {
        try {
            this.tester.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=issuetype&selectedLocale=fr_FR");
            this.tester.setWorkingForm("update");
            this.tester.setFormElement("jira.translation.Issue Type.1.name", TRANSLATED_BUG_NAME);
            this.tester.setFormElement("jira.translation.Issue Type.1.desc", TRANSLATED_BUG_DESCRIPTION);
            this.tester.submit("update");
            this.tester.assertTextPresent(TRANSLATED_BUG_NAME);
            this.tester.assertTextPresent(TRANSLATED_BUG_DESCRIPTION);
            this.backdoor.userProfile().changeUserLanguage("admin", "fr_FR");
            this.tester.gotoPage("secure/ShowConstantsHelp.jspa");
            this.tester.assertTextPresent(TRANSLATED_BUG_NAME);
            this.tester.assertTextPresent(TRANSLATED_BUG_DESCRIPTION);
            this.navigation.issue().viewPrintable("HSP-3");
            this.textAssertions.assertTextSequence(this.locator.page().getHTML(), "Type:", TRANSLATED_BUG_NAME);
        }
        finally {
            this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
        }
    }

    private void assertIssueConstantHTMLTitlesPresent() {
        this.assertIssueConstantStraightHTMLNotPresent();
        this.tester.assertTextPresent("title=\"name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;");
        this.assertLozengePresent(STATUS_NAME_HTML_ESC);
        this.assertLozengePresent(STATUS_NAME_TEXT);
    }

    private void assertIssueConstantHTMLPresentInXML() {
        this.assertIssueConstantStraightHTMLNotPresent();
        String pageHtml = this.tester.getDialog().getResponseText();
        this.textAssertions.assertTextSequence(pageHtml, new String[]{"<type id=\"1\"", ">", ISSUE_TYPE_NAME_HTML_ESC, "</type>"});
        this.textAssertions.assertTextSequence(pageHtml, new String[]{"<priority id=\"1\"", ">", PRIORITY_NAME_HTML_ESC, "</priority>"});
        this.textAssertions.assertTextSequence(pageHtml, new String[]{"<resolution id=\"1\"", ">", RESOLUTION_NAME_HTML_ESC, "</resolution>"});
    }

    private void assertIssueConstantHTMLContentViewPresent() {
        this.assertIssueConstantStraightHTMLNotPresent();
        String pageHtml = this.tester.getDialog().getResponseText();
        this.textAssertions.assertTextSequence(pageHtml, "Type:", ISSUE_TYPE_NAME_HTML_ESC);
        this.textAssertions.assertTextSequence(pageHtml, "Priority:", PRIORITY_NAME_HTML_ESC);
        this.textAssertions.assertTextSequence(pageHtml, "Status:", STATUS_NAME_HTML_ESC);
    }

    private void assertIssueConstantStraightHTMLNotPresent() {
        this.tester.assertTextNotPresent(ISSUE_TYPE_NAME_HTML);
        this.tester.assertTextNotPresent(PRIORITY_NAME_HTML);
        this.tester.assertTextNotPresent(STATUS_NAME_HTML);
        this.tester.assertTextNotPresent(ISSUE_TYPE_DESC_HTML);
        this.tester.assertTextNotPresent(PRIORITY_DESC_HTML);
        this.tester.assertTextNotPresent(STATUS_DESC_HTML);
    }

    private void selectIssuesForBulkOperation() {
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.navigation.clickOnNext();
    }
}

