/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentClient;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionClient;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY})
@LoginAs(user="admin")
public class TestIssueSecurityActions
extends BaseJiraFuncTest {
    private static final String DEFAULT_FIELD_CONFIG = "Default Field Configuration";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        if (this.administration.project().projectWithKeyExists("HSP")) {
            this.logger.log((Object)"Project 'homospaien' exists");
            if (!this.componentExists("New Component 1", "homosapien")) {
                this.addComponent("homosapien", "New Component 1");
            }
            if (!this.versionExists("New Version 1", "homosapien")) {
                this.addVersion("homosapien", "New Version 1", "Version 1");
            }
        } else {
            this.administration.project().addProject("homosapien", "HSP", "admin");
            this.addComponent("homosapien", "New Component 1");
            this.addVersion("homosapien", "New Version 1", "Version 1");
        }
        if (this.administration.project().projectWithKeyExists("NDT")) {
            this.logger.log((Object)"Project 'neanderthal' exists");
        } else {
            this.administration.project().addProject("neanderthal", "NDT", "admin");
        }
        if (this.securtiySchemeExists("New Security Scheme")) {
            this.administration.project().removeAssociationOfIssueLevelSecurityScheme("homosapien");
            this.administration.project().removeAssociationOfIssueLevelSecurityScheme("neanderthal");
            this.deleteSecurityScheme("New Security Scheme");
        }
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        try {
            this.tester.assertLinkPresentWithText("bob");
        }
        catch (Throwable t) {
            this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        }
        this.editIssueFieldVisibility.resetFields();
    }

    @Test
    @RestoreBlankInstance
    public void testIssueSecurityActions() {
        String issueKeyWithoutSecurity = this.backdoor.issues().createIssue("NDT", "test without issue security", "admin", "Minor", "Bug").key();
        this.backdoor.issues().setIssueFields(issueKeyWithoutSecurity, new IssueFields().environment("test environment 1").description("test description without issue security"));
        String issueKeyNormal = this.backdoor.issues().createIssue("HSP", "test with components", "admin", "Minor", "Bug").key();
        this.backdoor.issues().setIssueFields(issueKeyNormal, new IssueFields().environment("test environment 1").description("test description with components"));
        this.issueSecurityCreateScheme();
        this.issueSecurityFieldSchemesAddDuplicateScheme();
        this.issueSecurityFieldSchemesAddInvalidScheme();
        this.issueSecurityAddSecurityLevel();
        this.issueSecurityAssociateSchemeToProject();
        this.issueSecurityAddGroupToSecurityLevel();
        String issueKeyWithSecurity = this.issueSecurityCreateIssueWithSecurity();
        this.issueSecurityCreateIssueWithoutIssueSecurity();
        this.issueSecurityCreateIssueWithSecurityRequired();
        this.issueSecurityEditIssueWithIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityEditIssueWithoutIssueSecurity(issueKeyWithoutSecurity);
        this.issueSecurityEditIssueWithSecurityRequired(issueKeyNormal);
        this.issueSecuritySecurityViolation(issueKeyWithSecurity);
        this.issueSecurityMoveIssueAwayFromIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityMoveIssueToIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityMoveIssueWithDefaultSecurity(issueKeyWithoutSecurity);
        this.issueSecurityMoveIssueWithSameSecurity(issueKeyWithoutSecurity);
        this.issueSecurityCreateSubTaskWithSecurity(issueKeyWithSecurity);
        this.issueSecurityRemoveAssociationWithProject();
        this.issueSecurityRemoveGroupFromSecurityLevel();
        this.issueSecurityDeleteSecurityLevel();
        this.issueSecurityDeleteScheme();
    }

    @Test
    @Restore(value="TestIssueSecurityScheme.xml")
    public void testProjectRoleIssueSecurityType() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.assertTextNotPresent("(Administrators)");
        this.tester.clickLink("add_level 1");
        this.tester.checkCheckbox("type", "projectrole");
        this.tester.selectOption("projectrole", "Administrators");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("(Administrators)");
    }

    public boolean securtiySchemeExists(String securityScheme) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        return this.tester.getDialog().isTextInResponse(securityScheme);
    }

    public String addVersion(String project, String name, String description) {
        this.logger.log((Object)("Adding version '" + name + "' to project '" + project + "'"));
        VersionClient versionClient = new VersionClient((JIRAEnvironmentData)this.environmentData);
        Version version = new Version();
        version.project(project).name(name).description(description);
        versionClient.create(version);
        return "" + version.id;
    }

    private boolean componentExists(String component, String project) {
        Project projectByName = this.getProjectByName(project);
        Component componentByname = this.getComponentByname(projectByName.key, component);
        return componentByname != null;
    }

    private boolean versionExists(String version, String project) {
        Project projectByName = this.getProjectByName(project);
        Version versionByName = this.getVersionByName(projectByName.key, version);
        return versionByName != null;
    }

    private Version getVersionByName(String projectKey, String versionName) {
        ProjectClient projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List versions = projectClient.getVersions(projectKey);
        for (Version version : versions) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return null;
    }

    private String addComponent(String projectName, String name) {
        return this.addComponent(projectName, name, null);
    }

    private String addComponent(String projectName, String name, String componentLead) {
        Project project = this.getProjectByName(projectName);
        Component componentByname = this.getComponentByname(project.key, name);
        if (componentByname != null) {
            return "" + componentByname.id;
        }
        ComponentClient componentClient = new ComponentClient((JIRAEnvironmentData)this.environmentData);
        Component component = componentClient.create(new Component().project(project.key).name(name).leadUserName(componentLead));
        return "" + component.id;
    }

    private Component getComponentByname(String projectKey, String componentName) {
        ProjectClient projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List components = projectClient.getComponents(projectKey);
        for (Component component : components) {
            if (!component.name.equals(componentName)) continue;
            return component;
        }
        return null;
    }

    private Project getProjectByName(String projectName) {
        ProjectClient projectClient = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List projects = projectClient.getProjects();
        for (Project project : projects) {
            if (!project.name.equals(projectName)) continue;
            return project;
        }
        return null;
    }

    public void issueSecurityCreateScheme() {
        this.logger.log((Object)"Issue Security: Creating a security scheme");
        this.createSecurityScheme("New Security Scheme", "security scheme for testing");
        this.tester.assertTextPresent("Issue Security Schemes");
        this.tester.assertLinkPresentWithText("New Security Scheme");
    }

    public void issueSecurityDeleteScheme() {
        this.logger.log((Object)"Issue Security: Deleting a security scheme");
        this.deleteSecurityScheme("New Security Scheme");
        this.tester.assertLinkNotPresentWithText("New Security Scheme");
        this.tester.assertTextPresent("You do not currently have any issue security schemes configured.");
    }

    private void createSecurityScheme(String scheme_name, String scheme_description) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLink("add_securityscheme");
        this.tester.assertTextPresent("Add issue security scheme");
        this.tester.setFormElement("name", scheme_name);
        this.tester.setFormElement("description", scheme_description);
        this.tester.submit("Add");
    }

    private void deleteSecurityScheme(String scheme_name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLink("del_" + scheme_name);
        this.tester.assertTextPresent("Delete Issue Security Scheme");
        this.tester.assertTextPresent(scheme_name);
        this.tester.submit("Delete");
    }

    public void issueSecurityAddSecurityLevel() {
        this.logger.log((Object)"Issue Security: Adding a security level to a security scheme");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").newLevel("Red", "Highest Level");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Red", "Highest Level"});
        this.tester.assertTextNotPresent("Orange");
        this.tester.assertTextNotPresent("Middle Level");
        this.tester.assertTextNotPresent("Green");
        this.tester.assertTextNotPresent("Lowest Level");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").newLevel("Orange", "Middle Level");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Orange", "Middle Level", "Red", "Highest Level"});
        this.tester.assertTextNotPresent("Green");
        this.tester.assertTextNotPresent("Lowest Level");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").newLevel("Green", "Lowest Level");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Green", "Lowest Level", "Orange", "Middle Level", "Red", "Highest Level"});
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("New Security Scheme");
        this.tester.assertLinkPresent("add_Red");
        this.tester.assertLinkPresent("add_Orange");
        this.tester.assertLinkPresent("add_Green");
    }

    public void issueSecurityDeleteSecurityLevel() {
        this.logger.log((Object)"Issue Security: Deleting a security level to a security scheme");
        this.deleteSecurityLevel("New Security Scheme", "Red");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("New Security Scheme");
        this.tester.assertLinkNotPresent("add_Red");
        this.tester.assertLinkPresent("add_Orange");
        this.tester.assertLinkPresent("add_Green");
    }

    private void deleteSecurityLevel(String scheme_name, String level_name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText(scheme_name);
        this.tester.clickLink("delLevel_" + level_name);
        this.tester.assertTextPresent("Delete Issue Security Level: " + level_name);
        this.tester.submit("Delete");
    }

    public void issueSecurityAssociateSchemeToProject() {
        this.logger.log((Object)"Issue Security: Associate a Project to a Scheme");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "New Security Scheme");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((String)"HSP").issueSecurityScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New Security Scheme"));
    }

    public void issueSecurityRemoveAssociationWithProject() {
        this.logger.log((Object)"Issue Security: Remove association between a Project and a Scheme");
        this.administration.project().removeAssociationOfIssueLevelSecurityScheme("homosapien");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((String)"HSP").issueSecurityScheme, (Matcher)CoreMatchers.nullValue());
    }

    public void issueSecurityAddGroupToSecurityLevel() {
        this.logger.log((Object)"Issue Security: Add groups to issue security level");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Red").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-administrators");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Orange").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-developers");
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Green").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-users");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("New Security Scheme");
        this.tester.assertLinkPresent("delGroup_jira-administrators_Red");
        this.tester.assertLinkPresent("delGroup_jira-developers_Orange");
        this.tester.assertLinkPresent("delGroup_jira-users_Green");
    }

    public void issueSecurityRemoveGroupFromSecurityLevel() {
        this.logger.log((Object)"Issue Security: Remove groups from issue security level");
        this.removeGroupFromSecurityLevel("New Security Scheme", "Red", "jira-administrators");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("New Security Scheme");
        this.tester.assertLinkNotPresent("delGroup_jira-administrators_Red");
        this.tester.assertLinkPresent("delGroup_jira-developers_Orange");
        this.tester.assertLinkPresent("delGroup_jira-users_Green");
    }

    public void issueSecurityFieldSchemesAddDuplicateScheme() {
        this.logger.log((Object)"Issue Security: Creating a duplicate security scheme");
        this.createSecurityScheme("New Security Scheme", "security scheme for testing");
        this.tester.assertTextPresent("A Scheme with this name already exists.");
    }

    public void issueSecurityFieldSchemesAddInvalidScheme() {
        this.logger.log((Object)"Issue Security: Creating a duplicate security scheme");
        this.createSecurityScheme("", "");
        this.tester.assertTextPresent("Please specify a name for this Scheme.");
    }

    public String issueSecurityCreateIssueWithSecurity() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "test with issue security");
        this.navigation.issue().setPriority(issueKey, "Minor");
        this.navigation.issue().setSecurity(issueKey, "Red");
        this.navigation.issue().setAffectsVersions(issueKey, "New Version 1");
        this.navigation.issue().setFixVersions(issueKey, "New Version 1");
        this.navigation.issue().setComponents(issueKey, "New Component 1");
        this.navigation.issue().setEnvironment(issueKey, "test environment 9");
        this.navigation.issue().setDescription(issueKey, "test description 9");
        this.tester.assertTextPresent("test with issue security");
        this.tester.assertTextPresent("Minor");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("test environment 9");
        this.tester.assertTextPresent("New Version 1");
        this.tester.assertTextPresent("New Component 1");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Red");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        return issueKey;
    }

    public void issueSecurityCreateIssueWithoutIssueSecurity() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.logger.log((Object)"Create Issue: Tests the availability of the 'Security Level' field");
        this.navigation.issue().goToCreateIssueForm("neanderthal", "Bug");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("neanderthal");
        this.tester.assertFormElementNotPresent("security");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityCreateIssueWithSecurityRequired() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.editIssueFieldVisibility.setSecurityLevelToRequried();
        this.logger.log((Object)"Create Issue: Test the ability to create an issue with 'Security Level' required");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "This is a summary");
        this.tester.submit("Create");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.assertTextPresent("Security Level is required.");
        this.editIssueFieldVisibility.resetFields();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityEditIssueWithIssueSecurity(String issueKey) {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.logger.log((Object)"Edit Issue: Test ability to change Security Level");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("security", "Orange");
        this.tester.submit();
        this.tester.assertTextPresent(issueKey);
        this.tester.assertTextPresent("Orange");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityEditIssueWithoutIssueSecurity(String issueKey) {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.logger.log((Object)"Edit Issue: Test availability of 'Security Level' field");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("security");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityEditIssueWithSecurityRequired(String issueKey) {
        this.editIssueFieldVisibility.setSecurityLevelToRequried();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.logger.log((Object)"Edit Issue: Test the ability to update an issue with 'Security Level' required");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.assertTextPresent("Security Level is required.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.editIssueFieldVisibility.resetFields();
    }

    public void issueSecuritySecurityViolation(String issueKey) {
        this.logger.log((Object)"Edit Issue: Test the availabilty of an issue for which a user is not permitted to view.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.navigation.issue().gotoIssue(issueKey);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityMoveIssueAwayFromIssueSecurity(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving an issue to a project without 'Issue Security");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextNotPresent("All fields will be updated automatically.");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.assertTextPresent("neanderthal");
        this.tester.assertTextPresent("homosapien");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit("Move");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertTextNotPresent("Red");
    }

    public void issueSecurityMoveIssueToIssueSecurity(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving an issue to a project with 'Issue Security");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.selectOption("security", "Orange");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Orange");
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "jira-administrators");
    }

    public void issueSecurityMoveIssueWithDefaultSecurity(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving an issue with default security levels");
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Security Level: Security Level is required.");
        this.setDefaultSecurityLevel("New Security Scheme", "Red");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Red");
        this.setDefaultSecurityLevel("New Security Scheme", null);
        this.editIssueFieldVisibility.setOptionalFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
    }

    public void issueSecurityMoveIssueWithSameSecurity(String issueKey) {
        this.logger.log((Object)"Move Operation: Move an issue to a project with the same issue security scheme.");
        this.administration.project().associateIssueLevelSecurityScheme("neanderthal", "New Security Scheme");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Update Fields");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertTextPresent("Red");
        this.administration.project().removeAssociationOfIssueLevelSecurityScheme("neanderthal");
    }

    public void issueSecurityCreateSubTaskWithSecurity(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Create a sub task from an issue with a security level");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("test with issue security");
        this.tester.assertTextPresent("Sub Task of Test 5");
        this.tester.assertTextPresent("Orange");
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
    }

    private void setDefaultSecurityLevel(String scheme_name, String securityLevel) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText(scheme_name);
        if (securityLevel != null) {
            this.tester.clickLink("default_" + securityLevel);
        } else {
            this.tester.clickLinkWithText("Change default security level to \"None\"");
        }
    }

    public void removeGroupFromSecurityLevel(String scheme_name, String level_name, String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText(scheme_name);
        this.tester.clickLink("delGroup_" + groupName + "_" + level_name);
        this.tester.submit("Delete");
    }

    private void deleteCurrentIssue() {
        this.tester.clickLink("delete-issue");
        this.tester.setWorkingForm("delete-issue");
        this.tester.submit("Delete");
    }
}

