/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestIssueTabPanels.xml")
public class TestIssueTabPanels
extends BaseJiraFuncTest {
    private static final String SORT_ICON_CONTAINER_LOCATOR = "//*[@id='activitymodule']//div[contains(concat(' ', normalize-space(@class), ' '), ' sortwrap ')]";
    private final String commentLorem = "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private EnvironmentUtils environmentUtils;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.backdoor.applicationProperties().setString("jira.baseurl", this.backdoor.applicationProperties().getEnvironmentData().getBaseUrl().toString());
    }

    @Test
    public void testShouldDefaultToCommentsTab() {
        this.navigation.issue().viewIssue("MKY-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
    }

    @Test
    public void testSelectedTabPanelIsStickyDuringTheSession() {
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLinkWithText("History");
        this.navigation.issue().viewIssue("MKY-1");
        Assert.assertTrue((String)"Did not remember that we clicked on the 'History' panel.", (boolean)this.locator.css("#changehistory-tabpanel.active").exists());
        Assert.assertFalse((String)"The comments panel should not be active.", (boolean)this.locator.css("#comment-tabpanel.active").exists());
    }

    @Test
    public void testViewDefaultPanelWhenRequestedPanelDoesNotExist() {
        this.tester.gotoPage("browse/MKY-1?page=unknown");
        this.textAssertions.assertTextPresent(this.locator.id("issue_actions_container"), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "An unknown error occurred - actions == null. Please see logs for more details.");
    }

    @Test
    public void testSortOrderIsShownForIssueTabs() {
        String DEFAULT_SORT_ORDER_TEXT = "Newest first";
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Achangehistory-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Achangehistory-tabpanel");
        this.textAssertions.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel");
        this.textAssertions.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.textAssertions.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Newest first");
    }

    @Test
    public void testPermalinking() {
        this.navigation.gotoDashboard();
        String worklogPermalink = "/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001";
        String worklogLorem = "Cras hendrerit porta tortor. Ut varius";
        String commentPermalink = "/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001";
        this.tester.gotoPage("/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001");
        this.textAssertions.assertTextPresent(this.locator.page(), "Cras hendrerit porta tortor. Ut varius");
        this.navigation.gotoDashboard();
        this.tester.gotoPage("/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001");
        this.textAssertions.assertTextPresent(this.locator.page(), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
    }
}

