/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryParser;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.JQL})
@LoginAs(user="admin")
public class TestLabels
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testSearching() {
        this.administration.restoreData("TestLabels.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this._testSearching("labels", "labels", "Label", false);
    }

    @Test
    public void testCustomFieldSearching() {
        this.administration.restoreData("TestLabels.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this._testSearching("customfield_10000", "Epic", "Epic", true);
    }

    @Test
    public void testNoEditWhenClosed() throws Exception {
        this.administration.restoreData("TestLabels.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "closing for testing purposes");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertions.assertNodeDoesNotExist("//*[contains(@class, 'edit-labels')]");
        this.navigation.issueNavigator().createSearch("key = \"HSP-1\"");
        this.assertions.assertNodeDoesNotExist("id('labels-10001-value')//*[contains(@class, 'edit-labels')]");
        this.assertions.assertNodeDoesNotExist("id('customfield_10000-10001-value')//*[contains(@class, 'edit-labels')]");
    }

    private void _testSearching(String fieldId, String field, String fieldName, boolean custom) {
        this.navigation.issueNavigator().createSearch(field + " in (aa, TeSt)");
        TableLocator locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextPresent(locator, "HSP-2");
        this.textAssertions.assertTextPresent(locator, "HSP-1");
        this.navigation.issueNavigator().createSearch(field + " = \"fIRst\"");
        locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextPresent(locator, "HSP-1");
        this.textAssertions.assertTextNotPresent(locator, "HSP-2");
        this.navigation.issueNavigator().createSearch(field + " is empty");
        this.tester.assertElementNotPresent("issuetable");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Another test issue!!!!");
        this.navigation.issueNavigator().createSearch(field + " is empty");
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "No matching issues found. ");
        locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextPresent(locator, issueKey);
        this.navigation.issueNavigator().createSearch(field + " in (TeST, aa)");
        locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextPresent(locator, "HSP-1");
        this.textAssertions.assertTextPresent(locator, "HSP-2");
        this.navigation.issueNavigator().createSearch(field + " != couple");
        locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextPresent(locator, "HSP-2");
        this.textAssertions.assertTextNotPresent(locator, "HSP-1");
        this.textAssertions.assertTextNotPresent(locator, "HSP-3");
        this.navigation.issueNavigator().createSearch(field + " not in (aa, bb)");
        locator = new TableLocator(this.tester, "issuetable");
        this.textAssertions.assertTextNotPresent(locator, "HSP-2");
        this.textAssertions.assertTextPresent(locator, "HSP-1");
        this.textAssertions.assertTextNotPresent(locator, "HSP-3");
    }

    @Test
    public void testEditIssueLabelsDoesCreateChangeItem() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoEditIssue("HSP-3");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "issue-edit", "Update");
        formParameterUtil.addOptionToHtmlSelect("labels", new String[]{"Label"});
        formParameterUtil.submitForm();
        this.navigation.issue().gotoIssueChangeHistory("HSP-3");
        this.assertHistoryContains("Administrator", "Labels", "", "Label");
    }

    @Test
    public void testCreateIssueLabelsDoesNotCreateChangeItem() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        Map<String, String[]> params = MapBuilder.newBuilder().add("labels", new String[]{"label"}).toMap();
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Bug With Labels", params);
        this.navigation.issue().gotoIssueChangeHistory(issueKey);
        this.assertNoHistory();
    }

    @Test
    public void testEditIssueLabelsStandaloneDoesNotSuck() {
        Labels expectedLabels = new Labels(true, true, true, "TEST", "aaafirst", "couple", "first", "labels", "of", "test");
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        String labelsDomId = "labels-10000-labels";
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
        this.navigation.issue().editLabels(10000);
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='id']");
        this.assertions.assertNodeExists("//select[@id='labels']");
        this.tester.submit("edit-labels-submit");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
    }

    @Test
    public void testEditCustomIssueLabelsStandaloneDoesNotSuck() {
        String customFieldName = "customfield_10000";
        String labelsDomId = "labels-10000-customfield_10000";
        Labels expectedLabels = new Labels(true, true, true, "TEST", "aaafirst", "couple", "first", "labels", "of", "test");
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
        this.navigation.issue().editCustomLabels(10000, 10000);
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='id']");
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='customFieldId']");
        this.assertions.assertNodeExists("//select[@id='customfield_10000']");
        this.tester.submit("edit-labels-submit");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
    }

    @Test
    public void testCancelOnEditLabelsStandaloneNavigatesToIssue() {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editLabels(10000);
        this.tester.clickLink("cancel");
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage("HSP-1");
    }

    @Test
    public void testEditSystemLabelsValidation() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editLabels(10000);
        FormParameterUtil parameterUtil = new FormParameterUtil(this.tester, "edit-labels-form", "edit-labels-submit");
        this._addInvalidLabel(parameterUtil);
        this._assertLabelValidation("labels", parameterUtil);
    }

    @Test
    public void testEditCustomLabelsValidation() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editCustomLabels(10000, 10000);
        FormParameterUtil parameterUtil = new FormParameterUtil(this.tester, "edit-labels-form", "edit-labels-submit");
        this._addInvalidLabel(parameterUtil);
        this._assertLabelValidation("customfield_10000", parameterUtil);
    }

    @Test
    public void testLabelsJqlLinks() throws UnsupportedEncodingException {
        this.administration.restoreData("TestLabelsWithIssuesForJQL.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        int issueId = 10000;
        int customFieldId = 10000;
        String[] indexToLabel = new String[]{"TEST", "aaafirst", "couple", "\"first\"", "labels", "\"of\"", "test"};
        for (int i = 0; i < indexToLabel.length; ++i) {
            String issueToCheck = "HSP-" + (i + 4);
            String summaryToCheck = "Issue for " + indexToLabel[i];
            this.navigation.issue().gotoIssue("HSP-1");
            this.assertJqlLinkForLabel(10000, null, i, indexToLabel[i], summaryToCheck, issueToCheck);
            this.navigation.issue().gotoIssue("HSP-1");
            this.assertJqlLinkForLabel(10000, 10000, i, indexToLabel[i], summaryToCheck, issueToCheck);
        }
    }

    private void assertJqlLinkForLabel(int issueId, Integer customFieldId, int labelIndex, String labelText, String issueSummary, String issue) throws UnsupportedEncodingException {
        String fieldId = null;
        String fieldName = null;
        if (customFieldId == null) {
            fieldName = "labels";
            fieldId = "labels";
        } else {
            fieldId = "customfield_" + customFieldId;
            fieldName = "cf[" + customFieldId + "]";
        }
        String jqlHref = this.locator.xpath("//ul[@id='" + fieldId + "-" + issueId + "-value']//a").getNodes()[labelIndex].getAttributes().getNamedItem("href").getNodeValue();
        this.tester.gotoPage(jqlHref.replace(this.getEnvironmentData().getContext(), ""));
        String url = URLDecoder.decode(this.tester.getDialog().getResponse().getURL().toString(), "UTF-8");
        Assert.assertThat((Object)url, (Matcher)Matchers.containsString((String)(fieldName + " = " + labelText)));
        this.tester.assertTextInElement("issuetable", issueSummary);
        this.tester.assertTextInElement("issuetable", issue);
    }

    private void _addInvalidLabel(FormParameterUtil formParameterUtil) {
        formParameterUtil.addOptionToHtmlSelect("labels", new String[]{"A B"});
    }

    private void _assertLabelValidation(String fieldName, FormParameterUtil formParameterUtil) throws IOException, SAXException {
        String domId = fieldName + "-error";
        XPathLocator locator = new XPathLocator(formParameterUtil.submitForm(), String.format("//*[@id='%s']", domId));
        Assert.assertNotNull((String)String.format("%s-error should exist", domId), (Object)locator.getNode());
    }

    private void assertNoHistory() throws Exception {
        ChangeHistoryList actualList = ChangeHistoryParser.getChangeHistory(this.tester);
        Assert.assertTrue((boolean)actualList.isEmpty());
    }

    private void assertHistoryContains(String changedBy, String fieldName, String oldValue, String newValue) throws Exception {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet(changedBy).add(fieldName, oldValue, newValue);
        ChangeHistoryList actualList = ChangeHistoryParser.getChangeHistory(this.tester);
        actualList.assertContainsChangeHistory(expectedList);
    }
}

