/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Test;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.FIELDS, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestLabelsFormat.xml")
public class TestLabelsFormats
extends BaseJiraFuncTest {
    private static final String HSP1_ID = "10000";
    private static final String HSP2_ID = "10001";
    private static final String LABELS_FIELD = "labels";
    private static final String EPIC_FIELD = "customfield_10000";
    private static final Set<String> EMPTY_LABELS = CollectionBuilder.newBuilder().asHashSet();
    private static final Set<String> EXPECTED_LABELS = CollectionBuilder.newBuilder("1111", "2222", "333,333", "444").asHashSet();
    private static final Set<String> EXPECTED_EPICS = CollectionBuilder.newBuilder("aaa", "bbbb", "cccc,ccc", "dddd").asHashSet();
    private static final String NEW = "new_";
    private static final String OLD = "old_";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_2 = "HSP-2";
    @Inject
    private HtmlPage page;

    @Test
    public void testViewIssue() {
        this.navigation.issue().viewIssue(HSP_1);
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        Labels expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issue().viewPrintable(HSP_1);
        expectedLabels = new Labels(false, false, false, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, false, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issue().viewIssue(HSP_2);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
        this.navigation.issue().viewPrintable(HSP_2);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
        this.navigation.issue().viewIssue(HSP_2);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.clickButton("next_submit");
        this.navigation.sendPostRequest("/secure/MoveIssueUpdateFields.jspa", new ByteArrayInputStream(("id=10001&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS) + "&" + "atl_token" + "=" + this.page.getXsrfToken()).getBytes(StandardCharsets.US_ASCII)));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, "old_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "old_customfield_10000", expectedEpic);
        this.navigation.issue().viewIssue(HSP_2);
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", HSP_1);
        this.tester.clickButton("next_submit");
        Element guid = this.tester.getDialog().getElement("guid");
        String guidStr = guid.getAttribute("value");
        this.navigation.gotoPage("/secure/ConvertIssueUpdateFields.jspa?id=10001&guid=" + guidStr + "&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, "old_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "old_customfield_10000", expectedEpic);
    }

    @Test
    public void testIssueNav() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        Labels expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issueNavigator().displayPrintableAllIssues();
        expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issueNavigator().displayFullContentAllIssues();
        expectedLabels = new Labels(false, false, false, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, false, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
    }

    @Test
    public void testBulkOperations() {
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        this.navigation.issueNavigator().bulkEditAllIssues();
        Labels expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        String url = "/secure/BulkEditDetailsValidation.jspa?actions=labels&actions=customfield_10000&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS);
        this.navigation.gotoPage(this.page.addXsrfToken(url));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectIssueType("New Feature", "10000_1_issuetype");
        this.tester.submit("Next");
        this.navigation.gotoPage("/secure/BulkMigrateSetFields.jspa?" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "10000_1_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "10000_1_customfield_10000", expectedEpic);
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.setFormElement("wftransition", "jira_5_5");
        this.tester.submit("Next");
        this.navigation.gotoPage("/secure/BulkWorkflowTransitionEditValidation.jspa?actions=resolution&resolution=1&forcedResolution=resolution&actions=labels&actions=customfield_10000&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
    }

    private String createUrlString(String field, Set<String> labels) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String label : labels) {
            stringBuilder.append(field).append("=").append(label).append("&");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }
}

