/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestViewIssue
extends BaseJiraFuncTest {
    private static final String CLASSNAME_SUBTASK_PERCENTAGE_CELL = "progress";
    @Inject
    private Form form;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestViewIssueWithInvalidUsersProEnt.xml")
    public void testViewIssuePageWithInvalidAssigneeAndReporters() {
        this.backdoor.attachments().enable();
        this._testViewIssuePageWithInvalidAssigneeAndReportersStandard();
        this._testViewIssuePageWithInvalidAssigneeAndReportersProEnt();
    }

    @Test
    @Restore(value="TestEditedCommentAndWorklogWithMalformedDateFormat.xml")
    public void testEditedCommentVisibleWithDoubleQuotesInDateFormat() {
        this.navigation.issue().gotoIssueComments("HSP-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "this comment will not be edited", "this comment is edited");
        this.tester.assertTextPresent("title=\"Administrator - 24/Jul/07 09:47 AM&quot; \"");
        MatcherAssert.assertThat((Object)this.locator.css(".commentdate_10012_concise span time").getText(), (Matcher)Matchers.containsString((String)"25/Jul/07 09:48 AM\""));
        MatcherAssert.assertThat((Object)this.locator.css(".commentdate_10012_verbose span time").getText(), (Matcher)Matchers.containsString((String)"25/Jul/07 09:48 AM\""));
        this.navigation.issue().gotoIssueWorkLog("HSP-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "this work log will not be edited", "this work log is edited");
        this.tester.assertTextPresent("title=\"Administrator - 18/Jul/07 09:42 AM&quot; \"");
        MatcherAssert.assertThat((Object)this.locator.css("#worklog-10001 .actionContainer .action-details .date").getText(), (Matcher)Matchers.containsString((String)"18/Jul/07 09:43 AM\""));
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersStandard() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("Issue with valid user");
        IdLocator locator = new IdLocator(this.tester, "assignee-val");
        this.textAssertions.assertTextPresent(locator, "Administrator");
        locator = new IdLocator(this.tester, "reporter-val");
        this.textAssertions.assertTextPresent(locator, "Administrator");
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//span[@id='customfield_10000-val']"), "Administrator");
        this.textAssertions.assertTextPresent(new XPathLocator(this.tester, "//span[@id='customfield_10001-val']"), "Administrator");
        this.tester.assertLinkPresentWithText("Assign");
        this.tester.assertLinkPresentWithText("Attach file");
        this.tester.assertLinkPresentWithText("Clone");
        this.tester.assertLinkPresentWithText("Comment");
        this.tester.assertLinkPresentWithText("Delete");
        this.tester.assertLinkPresentWithText("Edit");
        this.tester.assertLinkPresent("view-voters");
        this.tester.assertLinkPresent("manage-watchers");
        this.tester.assertLinkPresentWithText("Log work");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertTextPresent("Issue with invalid users");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedassignee");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedreporter");
        this.assertions.assertNodeByIdExists("customfield_10000-val");
        this.assertions.assertNodeByIdExists("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.tester.assertLinkPresentWithText("Assign");
        this.tester.assertLinkPresentWithText("Attach file");
        this.tester.assertLinkPresentWithText("Clone");
        this.tester.assertLinkPresentWithText("Comment");
        this.tester.assertLinkPresentWithText("Delete");
        this.tester.assertLinkPresentWithText("Edit");
        this.tester.assertLinkPresent("view-voters");
        this.tester.assertLinkPresent("manage-watchers");
        this.tester.assertLinkPresentWithText("Log work");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersProEnt() {
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertLinkPresentWithText("sub-task");
        this.tester.assertLinkPresentWithText("Sub task with invalid user");
        this.navigation.issue().gotoIssue("HSP-3");
        this.tester.assertTextPresent("Sub task with invalid user");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedsubtaskuser");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedsubtaskuser");
        this.assertions.assertNodeByIdExists("customfield_10000-val");
        this.assertions.assertNodeByIdExists("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.tester.assertLinkPresentWithText("Assign");
        this.tester.assertLinkPresentWithText("Attach file");
        this.tester.assertLinkPresentWithText("Clone");
        this.tester.assertLinkPresentWithText("Comment");
        this.tester.assertLinkPresentWithText("Delete");
        this.tester.assertLinkPresentWithText("Edit");
        this.tester.assertLinkPresent("view-voters");
        this.tester.assertLinkPresent("manage-watchers");
        this.tester.assertLinkPresentWithText("Log work");
    }

    @Test
    @RestoreBlankInstance
    public void testSubtaskPercentageGraphPresence() {
        this.administration.subtasks().enable();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String parentKey = this.navigation.issue().createIssue("monkey", "Bug", "bonobo");
        String sub1Key = this.navigation.issue().createSubTask(parentKey, "Sub-task", "sub1", "subdesc1");
        this.navigation.issue().gotoIssue(parentKey);
        Assert.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.navigation.issue().createSubTask(parentKey, "Sub-task", "sub2", "subdesc2");
        this.navigation.issue().gotoIssue(parentKey);
        Assert.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.navigation.issue().gotoIssue(sub1Key);
        this.setEstimate("1m");
        this.navigation.issue().gotoIssue(parentKey);
        Assert.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.navigation.issue().logWork(sub1Key, "1m", "1m");
        this.tester.clickLink("parent_issue_summary");
        Assert.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.tester.assertTextPresent("50%");
        this.enableDeleteAllWorklogInDefaultPermissionScheme("jira-administrators");
        this.navigation.issue().gotoIssue(sub1Key);
        if (this.tester.getDialog().isLinkPresentWithText("Work Log")) {
            this.tester.clickLinkWithText("Work Log");
        }
        this.tester.clickLink("delete_worklog_10000");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue(parentKey);
        Assert.assertTrue((String)"Expected to still see graph after worklog deletion, original estimate remains", (boolean)this.isSubtaskPercentageGraphPresent());
    }

    @Test
    @Restore(value="TestProjectCFWithNoPermission.xml")
    public void testProjectCFNotLinkedWithNoPermission() {
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertLinkPresentWithText("homosapien");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.tester.assertTextPresent("monkey");
        this.navigation.login("admin");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertLinkPresentWithText("monkey");
    }

    @Test
    @RestoreBlankInstance
    public void testComponentOrdering() {
        this.logger.log((Object)"Testing ordering for components field");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Test issue");
        this.form.selectOptionsByDisplayName("components", "New Component 1", "New Component 3");
        this.tester.submit("Create");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.form.selectOptionsByDisplayName("components", "New Component 2", "New Component 1", "New Component 3");
        this.tester.submit("Update");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
        this.backdoor.components().putResponse("10000", this.backdoor.components().get("10000").archived(true));
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        MatcherAssert.assertThat(Arrays.asList(this.form.getForms()[1].getOptions("components")), (Matcher)Matchers.contains((Object[])new String[]{"Unknown", "New Component 2", "New Component 3"}));
        this.tester.submit("Update");
        Set issueComponents = this.backdoor.issues().getIssue((String)"HSP-1").fields.components.stream().map(component -> component.id).collect(Collectors.toSet());
        MatcherAssert.assertThat(issueComponents, (Matcher)Matchers.hasItem((Object)10000L));
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        MatcherAssert.assertThat(Arrays.asList(this.form.getForms()[1].getOptions("components")), (Matcher)Matchers.contains((Object[])new String[]{"Unknown", "New Component 2", "New Component 3"}));
        this.backdoor.components().putResponse("10000", this.backdoor.components().get("10000").archived(false));
        this.tester.submit("Update");
        issueComponents = this.backdoor.issues().getIssue((String)"HSP-1").fields.components.stream().map(component -> component.id).collect(Collectors.toSet());
        MatcherAssert.assertThat(issueComponents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)10000L)));
    }

    @Test
    @RestoreBlankInstance
    public void testVersionOrdering() {
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            this.logger.log((Object)("Testing ordering for versions field '" + versionField + "'"));
            this.tester.clickLink("create_link");
            this.tester.submit("Next");
            this.tester.setFormElement("summary", "Test issue");
            this.form.selectOptionsByDisplayName(versionField, "New Version 1", "New Version 5");
            this.tester.submit("Create");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.tester.clickLink("edit-issue");
            this.tester.setWorkingForm("issue-edit");
            this.form.selectOptionsByDisplayName(versionField, "New Version 4", "New Version 1", "New Version 5");
            this.tester.submit("Update");
            this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
        }
    }

    @Test
    @Restore(value="TestIssueFields.xml")
    public void testFieldTabs() throws Exception {
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertions.assertNodeByIdDoesNotExist("customfieldmodule");
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertions.assertNodeByIdExists("customfieldmodule");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.navigation.issue().gotoIssue("HSP-2");
        this.assertions.assertNodeByIdExists("customfieldmodule");
        this.tester.assertLinkNotPresentWithText("Tab2");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10001), "Tab2CF");
    }

    @Test
    @Restore(value="TestIssueFields.xml")
    public void testDateCustomFieldTabs() throws Exception {
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='datesmodule']//*[contains(@id, 'customfield')]");
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertions.assertNodeByIdDoesNotExist("customfieldmodule");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateCFTab2", "26/Jan/10");
        this.navigation.issue().gotoIssue("HSP-5");
        this.assertions.assertNodeByIdDoesNotExist("customfieldmodule");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "03/Jan/10", "DateTimeCFTab2", "29/Jan/10");
        this.navigation.issue().gotoIssue("HSP-6");
        this.assertions.assertNodeByIdExists("customfieldmodule");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "04/Jan/10", "DateTimeCFTab2", "12/Jan/10", "DateCFTab2", "19/Jan/10");
    }

    @Test
    @Restore(value="TestIssueFields.xml")
    public void testUserCustomFieldTabs() throws Exception {
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='peopledetails']//*[contains(@id, 'customfield')]");
        this.navigation.issue().gotoIssue("HSP-7");
        this.assertions.assertNodeByIdDoesNotExist("customfieldmodule");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator");
        this.navigation.issue().gotoIssue("HSP-8");
        this.assertions.assertNodeByIdExists("customfieldmodule");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator", "MultiGroupPickerCF", "jira-developers", "jira-users", "GroupPickerCF", "jira-administrators", "MultiUserPickerCF", "Administrator", "Fred Normal");
    }

    @Test
    @DevMode
    @Restore(value="TestIssueFields.xml")
    public void testArchivingFields() {
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertions.assertNodeByIdDoesNotExist("archiver-val");
        this.assertions.assertNodeByIdDoesNotExist("archiveddate-val");
        this.backdoor.issues().archiveIssue("HSP-4");
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertions.assertNodeByIdExists("archiveddate-val");
        this.assertions.assertNodeByIdHasText("archiver-val", "Administrator");
    }

    @Test
    @DevMode
    @Restore(value="TestIssueFields.xml")
    public void testProjectArchivingFields() {
        this.navigation.issue().gotoIssue("HSP-3");
        this.assertions.assertNodeByIdDoesNotExist("archiver-val");
        this.assertions.assertNodeByIdDoesNotExist("archiveddate-val");
        this.backdoor.project().archiveProject("HSP");
        this.navigation.issue().gotoIssue("HSP-4");
        this.assertions.assertNodeByIdExists("archiveddate-val");
        this.assertions.assertNodeByIdHasText("archiver-val", "Administrator");
    }

    @Test
    @Restore(value="TestIssueFields.xml")
    public void testUserCustomFieldWithMissingUsers() {
        this.navigation.issue().gotoIssue("HSP-9");
        this.assertions.assertNodeByIdExists("customfieldmodule");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.textAssertions.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.textAssertions.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "admin-xx", "MultiGroupPickerCF", "jira-developers", "jira-users", "GroupPickerCF", "jira-administrators", "MultiUserPickerCF", "Administrator", "fred-xx");
        this.tester.assertLinkNotPresentWithText("admin-xx");
        this.tester.assertLinkNotPresentWithText("fred-xx");
    }

    @Test
    @WebTest(value={Category.TIME_ZONES})
    @LoginAs(user="admin")
    @Restore(value="TestIssueFields.xml")
    public void testDatesShouldBeDisplayedInUserTimeZoneInViewIssuePage() {
        String MKY_1 = "MKY-1";
        String HONG_KONG = "Asia/Hong_Kong";
        String HONOLULU = "Pacific/Honolulu";
        String PAPUA_NEW_GUINEA = "Pacific/Port_Moresby";
        String CREATED_HK = "06/Mar/11 9:36 AM";
        String CREATED_HON = "05/Mar/11 3:36 PM";
        String CREATED_PNG = "06/Mar/11 11:36 AM";
        String UPDATED_HK = "06/Mar/11 9:43 AM";
        String UPDATED_HON = "05/Mar/11 3:43 PM";
        String UPDATED_PNG = "06/Mar/11 11:43 AM";
        String RESOLVED_HK = "06/Mar/11 9:41 AM";
        String RESOLVED_HON = "05/Mar/11 3:41 PM";
        String RESOLVED_PNG = "06/Mar/11 11:41 AM";
        String DATETIME_CF_HK = "09/Jun/11 6:30 AM";
        String DATETIME_CF_HON = "08/Jun/11 12:30 PM";
        String DATETIME_CF_PNG = "09/Jun/11 8:30 AM";
        String WORKLOG_HK = "06/Mar/11 9:38 AM";
        String WORKLOG_HON = "05/Mar/11 3:38 PM";
        String WORKLOG_PNG = "06/Mar/11 11:38 AM";
        String HISTORY_HK = "06/Mar/11 9:38 AM";
        String HISTORY_HON = "05/Mar/11 3:38 PM";
        String HISTORY_PNG = "06/Mar/11 11:38 AM";
        this.administration.generalConfiguration().setDefaultUserTimeZone("Asia/Hong_Kong");
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.createdDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:36 AM"));
        MatcherAssert.assertThat((Object)this.updatedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:43 AM"));
        MatcherAssert.assertThat((Object)this.resolvedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:41 AM"));
        MatcherAssert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)Matchers.equalTo((Object)"09/Jun/11 6:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        MatcherAssert.assertThat((Object)this.worklogDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        MatcherAssert.assertThat((Object)this.changeHistoryDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.userProfile().changeUserTimeZone("Pacific/Port_Moresby");
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.createdDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 11:36 AM"));
        MatcherAssert.assertThat((Object)this.updatedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 11:43 AM"));
        MatcherAssert.assertThat((Object)this.resolvedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 11:41 AM"));
        MatcherAssert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)Matchers.equalTo((Object)"09/Jun/11 8:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        MatcherAssert.assertThat((Object)this.worklogDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 11:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        MatcherAssert.assertThat((Object)this.changeHistoryDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 11:38 AM"));
        this.navigation.login("fred");
        this.navigation.userProfile().changeUserTimeZone("Pacific/Honolulu");
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.createdDate(), (Matcher)Matchers.equalTo((Object)"05/Mar/11 3:36 PM"));
        MatcherAssert.assertThat((Object)this.updatedDate(), (Matcher)Matchers.equalTo((Object)"05/Mar/11 3:43 PM"));
        MatcherAssert.assertThat((Object)this.resolvedDate(), (Matcher)Matchers.equalTo((Object)"05/Mar/11 3:41 PM"));
        MatcherAssert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)Matchers.equalTo((Object)"08/Jun/11 12:30 PM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        MatcherAssert.assertThat((Object)this.worklogDate(), (Matcher)Matchers.equalTo((Object)"05/Mar/11 3:38 PM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        MatcherAssert.assertThat((Object)this.changeHistoryDate(), (Matcher)Matchers.equalTo((Object)"05/Mar/11 3:38 PM"));
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.createdDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:36 AM"));
        MatcherAssert.assertThat((Object)this.updatedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:43 AM"));
        MatcherAssert.assertThat((Object)this.resolvedDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:41 AM"));
        MatcherAssert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)Matchers.equalTo((Object)"09/Jun/11 6:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        MatcherAssert.assertThat((Object)this.worklogDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        MatcherAssert.assertThat((Object)this.changeHistoryDate(), (Matcher)Matchers.equalTo((Object)"06/Mar/11 9:38 AM"));
    }

    @Test
    @Restore(value="TestImageUrlXss.xml")
    public void testXssInImageUrls() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('prioritiezz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('issue typezz');&lt;/script&gt;");
    }

    @Test
    @WebTest(value={Category.TIME_ZONES})
    @LoginAs(user="admin")
    @Restore(value="TestIssueFields.xml")
    public void testDueDateShouldBeDisplayedInSystemTimeZone() {
        String MKY_1 = "MKY-1";
        String HONG_KONG = "Asia/Hong_Kong";
        String PAPUA_NEW_GUINEA = "Pacific/Port_Moresby";
        String DUE_DATE_STRING = "10/Jan/99";
        this.navigation.issue().gotoIssue("MKY-1");
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        MatcherAssert.assertThat((Object)this.dueDate(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.administration.generalConfiguration().setDefaultUserTimeZone("Asia/Hong_Kong");
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.dueDate(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        MatcherAssert.assertThat((Object)this.dueDate(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.navigation.userProfile().changeUserTimeZone("Pacific/Port_Moresby");
        this.navigation.issue().gotoIssue("MKY-1");
        MatcherAssert.assertThat((Object)this.dueDate(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        MatcherAssert.assertThat((Object)this.dueDate(), (Matcher)Matchers.equalTo((Object)"10/Jan/99"));
    }

    private String createdDate() {
        return this.locator.css("#created-val").getText();
    }

    private String dueDate() {
        return this.locator.css("#due-date").getText();
    }

    private String updatedDate() {
        return this.locator.css("#updated-val").getText();
    }

    private String resolvedDate() {
        return this.locator.css("#resolutiondate-val").getText();
    }

    private String dateTimeCfTab1() {
        return this.locator.css("#customfield_10010-val").getText();
    }

    private String worklogDate() {
        return this.locator.xpath("//*[@id='worklog-10000']//*[@class='subText']").getText();
    }

    private String changeHistoryDate() {
        return this.locator.css("#changehistorydetails_10030 time").getText();
    }

    private Locator createCFValueLocator(String tab, int id) {
        return new XPathLocator(this.tester, String.format("//*[@id='%s']//*[@id='customfield_%d-val']", tab, id));
    }

    private Locator createCFTabLocator(String tab) {
        return new XPathLocator(this.tester, String.format("//a[@href='#%s']", tab));
    }

    private void enableDeleteAllWorklogInDefaultPermissionScheme(String groupName) {
        this.logger.log((Object)("enabling delete all worklog deletion in default permission scheme for group " + groupName));
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS, groupName);
    }

    private boolean isSubtaskPercentageGraphPresent() {
        WebTable issueSummary = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        TableCell percentageCell = issueSummary.getTableCell(0, 5);
        return CLASSNAME_SUBTASK_PERCENTAGE_CELL.equals(percentageCell.getClassName());
    }

    protected void setEstimate(String time) {
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("timetracking", time);
        this.tester.submit("Update");
    }
}

