/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.google.common.base.Joiner;
import com.meterware.httpunit.HttpUnitOptions;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestWatchers
extends BaseJiraFuncTest {
    private static final Issue ISSUE = new Issue("HSP-1", 10000L);
    private static final String MANAGE_WATCHERS = "Watchers";
    private static final String ID_WATCH_LINK = "watching-toggle";
    private static final String ID_WATCH_SPAN = "watch-label";
    private static final String ID_VIEW_WATCHERS_LINK = "view-watcher-list";
    private static final String ID_WATCH_DATA = "watcher-data";
    private static final String ID_WATCH_ACTION = "toggle-watch-issue";
    private static final String ID_UNWATCH_ACTION = "toggle-unwatch-issue";
    private static final String ID_MANAGE_WATCHERS = "manage-watchers";
    private static final String XPATH_WATCHERS_SPAN_TITLE = String.format("//*[@id='%s']/@title", "watch-label");
    private static final String MSG_MUST_BE_LOGGED_IN = "You have to be logged in to watch an issue.";
    private static final String MSG_GUEST_PERM = "You must log in to access this page";
    private static final String TITLE_WATCHING = "Stop watching this issue";
    private static final String TITLE_WATCH = "Start watching this issue";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestWatchers.xml")
    @LoginAs(user="admin")
    public void testManageWatchers() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        try {
            this.watcherOperationRemove();
            this.watcherOperationDeleteWatcher();
            this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
            this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
            this.watcherOperationViewWatchingWithWatchPermission();
            this.watcherOperationWithManageandViewWatchingPermission();
            this.watcherOperationManageWatchingWithWatchPermission();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    @Test
    @Restore(value="TestWatchers.xml")
    public void testAnonymousUserCannotWatch() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.logout();
        this.gotoIssue(ISSUE);
        this.tester.assertLinkNotPresent(ID_WATCH_LINK);
        this.tester.assertLinkNotPresent(ID_WATCH_ACTION);
        this.assertTextPresentInElement(ID_WATCH_SPAN, TITLE_WATCH);
        Assert.assertEquals((Object)MSG_MUST_BE_LOGGED_IN, (Object)this.getXpathText(XPATH_WATCHERS_SPAN_TITLE));
        Assert.assertEquals((long)0L, (long)this.getWatchCount());
        this.watchIssueDirectly(ISSUE);
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), MSG_GUEST_PERM);
        this.gotoIssue(ISSUE);
        Assert.assertEquals((long)0L, (long)this.getWatchCount());
        this.navigation.login("admin", "admin");
    }

    @Test
    @Restore(value="TestWatchers.xml")
    public void testUserCanWatch() throws Exception {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.gotoIssue(ISSUE);
        this.assertNotWatching(0);
        this.tester.clickLink(ID_WATCH_LINK);
        this.assertWatching(1);
        this.watchIssueDirectly(ISSUE);
        this.assertWatching(1);
        this.tester.clickLink(ID_WATCH_LINK);
        this.assertNotWatching(0);
        this.unwatchIssueDirectly(ISSUE);
        this.assertNotWatching(0);
    }

    @Test
    @Restore(value="TestWatchersCannotAddUserWithNoPerms.xml")
    public void testCannotAddWatchersWhoDontHavePermissionToViewIssue() throws Exception {
        this._testCannotAddWatchersWhoDontHavePermissionToViewIssue("HSP-1");
        this._testCannotAddWatchersWhoDontHavePermissionToViewIssue("MKY-1");
    }

    @Test
    @Restore(value="TestWatchersCannotAddUserWithNoPerms.xml")
    public void testAddBadNames() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.setWorkingForm("startform");
        this.tester.submit("add");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "You must select a user.");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "nonexistentuser");
        this.tester.submit("add");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "The user \"nonexistentuser\" could not be found. This user will not be added to the watch list.");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "a, b, admin, c");
        this.tester.submit("add");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "The user \"a\" could not be found. This user will not be added to the watch list.");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "The user \"b\" could not be found. This user will not be added to the watch list.");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "The user \"c\" could not be found. This user will not be added to the watch list.");
        this.tester.assertLinkNotPresentWithText("Watch Issue");
        this.tester.assertLinkPresentWithText("Stop Watching");
    }

    @Test
    @Restore(value="TestWatchers.xml")
    public void testBackToIssueLink() {
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_VIEW_WATCHERS_LINK);
        this.assertions.assertNodeByIdExists("back-lnk");
        this.tester.clickLink("back-lnk");
        this.assertions.assertNodeByIdExists(ID_VIEW_WATCHERS_LINK);
    }

    private void _testCannotAddWatchersWhoDontHavePermissionToViewIssue(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertLinkPresentWithText("Watch Issue");
        this.tester.assertLinkNotPresentWithText("Stop Watching");
        this.tester.setWorkingForm("startform");
        this.tester.setFormElement("userNames", "fred, admin");
        this.tester.submit("add");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "The user \"fred\" does not have permission to view this issue. This user will not be added to the watch list.");
        this.tester.assertLinkNotPresentWithText("Watch Issue");
        this.tester.assertLinkPresentWithText("Stop Watching");
    }

    private void watcherOperationRemove() {
        this.logger.log((Object)"Watcher Operation: Test the ability to manage watchers");
        this.gotoIssue(ISSUE);
        this.startWatchingAnIssue();
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertTextPresent(MANAGE_WATCHERS);
        this.tester.assertLinkPresent("watcher_link_admin");
        this.tester.checkCheckbox("all");
        this.tester.assertCheckboxSelected("all");
        this.tester.getDialog().setWorkingForm("stopform");
        this.tester.submit();
        this.tester.assertTextPresent("There are no watchers.");
    }

    private void watcherOperationDeleteWatcher() {
        this.navigation.login("admin", "admin");
        this.logger.log((Object)"Watcher Operation: Test that a user's watcher association is removed when the user is deleted");
        this.gotoIssue(ISSUE);
        this.startWatchingAnIssue("bob", "admin");
        this.backdoor.usersAndGroups().deleteUser("bob");
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_VIEW_WATCHERS_LINK);
        this.tester.assertLinkNotPresent("watcher_link_bob");
        this.tester.assertLinkPresent("watcher_link_admin");
        this.gotoIssue(ISSUE);
        this.stopWatchingAnIssue();
    }

    private void watcherOperationViewWatchingWithWatchPermission() {
        this.logger.log((Object)"Watcher Operation: Test the availabilty of the 'View Watchers' Link with 'View Voters and Watchers' Permission");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.gotoIssue(ISSUE);
        this.assertManageLinksPresent();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MANAGE_WATCHERS, "jira-administrators");
        this.gotoIssue(ISSUE);
        this.assertManageLinksNotPresent();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-developers");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MANAGE_WATCHERS, "jira-administrators");
    }

    private void assertManageLinksPresent() {
        this.tester.assertLinkPresent(ID_VIEW_WATCHERS_LINK);
        this.tester.assertLinkPresent(ID_MANAGE_WATCHERS);
    }

    private void assertManageLinksNotPresent() {
        this.tester.assertLinkNotPresent(ID_MANAGE_WATCHERS);
        this.tester.assertLinkNotPresent(ID_VIEW_WATCHERS_LINK);
    }

    private void watcherOperationManageWatchingWithWatchPermission() {
        this.logger.log((Object)"Watcher Operation: Test the availabilty of the 'Manage Watchers'link with the 'Manage Watchers' Permission");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-developers");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.assertManageLinksNotPresent();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertTextPresent(MANAGE_WATCHERS);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-developers");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertTextNotPresent("Add Watchers");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.backdoor.permissionSchemes().addReporterPermission(0L, ProjectPermissions.MANAGE_WATCHERS);
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertTextNotPresent("Add Watchers");
    }

    private void watcherOperationWithManageandViewWatchingPermission() {
        this.logger.log((Object)"Watcher Operation: Test the difference between viewing and managing watcher lists");
        this.gotoIssue(ISSUE);
        this.startWatchingAnIssue();
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertFormElementPresent("stopwatch_admin");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-users");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.gotoIssue(ISSUE);
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertFormElementNotPresent("stopwatch_admin");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.gotoIssue(ISSUE);
        this.stopWatchingAnIssue();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, "jira-users");
    }

    private void assertTextPresentInElement(String elementId, String expectedText) {
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, elementId), expectedText);
    }

    private void assertWatching(int watcherCount) {
        this.tester.assertLinkPresent(ID_WATCH_LINK);
        this.tester.assertLinkPresent(ID_UNWATCH_ACTION);
        this.tester.assertTextInElement(ID_UNWATCH_ACTION, "Stop watching");
        this.assertTextPresentInElement(ID_WATCH_LINK, TITLE_WATCHING);
        Assert.assertEquals((long)watcherCount, (long)this.getWatchCount());
        this.tester.assertTextInElement(ID_UNWATCH_ACTION, "Stop watching");
    }

    private void assertNotWatching(int watcherCount) {
        this.tester.assertTextPresent(ID_WATCH_LINK);
        this.tester.assertLinkPresent(ID_WATCH_ACTION);
        this.tester.assertTextInElement(ID_WATCH_ACTION, "Watch");
        this.assertTextPresentInElement(ID_WATCH_LINK, TITLE_WATCH);
        Assert.assertEquals((long)watcherCount, (long)this.getWatchCount());
        this.tester.assertTextInElement(ID_WATCH_ACTION, "Watch");
    }

    private void gotoIssue(Issue issue) {
        this.navigation.issue().gotoIssue(issue.getKey());
    }

    private String getXpathText(String xpath) {
        return StringUtils.trimToNull((String)new XPathLocator(this.tester, xpath).getText());
    }

    private int getWatchCount() {
        String s = StringUtils.trimToNull((String)new IdLocator(this.tester, ID_WATCH_DATA).getText());
        if (s != null) {
            return Integer.parseInt(s);
        }
        Assert.fail((String)"Unable to find watch count.");
        return Integer.MIN_VALUE;
    }

    private void watchIssueDirectly(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&watch=watch", issue.getId())));
    }

    private void unwatchIssueDirectly(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&watch=unwatch", issue.getId())));
    }

    public void startWatchingAnIssue() {
        if (this.tester.getDialog().getResponseText().contains("watch-state-off")) {
            this.tester.clickLink(ID_WATCH_ACTION);
        }
        Assert.assertTrue((boolean)this.tester.getDialog().getResponseText().contains("watch-state-on"));
        this.tester.assertLinkPresent(ID_UNWATCH_ACTION);
    }

    private void stopWatchingAnIssue() {
        if (this.tester.getDialog().getResponseText().contains("watch-state-on")) {
            this.tester.clickLink(ID_UNWATCH_ACTION);
        }
        Assert.assertTrue((boolean)this.tester.getDialog().getResponseText().contains("watch-state-off"));
    }

    private void startWatchingAnIssue(String ... watchers) {
        this.tester.clickLink(ID_MANAGE_WATCHERS);
        this.tester.assertTextPresent(MANAGE_WATCHERS);
        this.tester.setFormElement("userNames", Joiner.on((char)',').join((Object[])watchers));
        this.tester.submit();
    }

    private static class Issue {
        private final String key;
        private final long id;

        private Issue(String key, long id) {
            this.key = key;
            this.id = id;
        }

        public String getKey() {
            return this.key;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

