/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.XPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestXMLIssueCustomView.xml")
@SinceBuildRule.SinceBuild(buildNumber=900000)
public class TestXmlIssueViewBackwardCompatibility
extends BaseJiraFuncTest {
    final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
    final String XML_VIEW_URL = "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml";
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;

    private String changeUrl(String baseUrl, String url) throws MalformedURLException {
        try {
            URI baseUri = new URI(baseUrl);
            URI uri = new URI(url);
            URI newUri = new URI(baseUri.getScheme(), baseUri.getAuthority(), baseUri.getPath() + uri.getPath().replaceFirst("/jira/", ""), uri.getQuery(), uri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException();
        }
    }

    private void assertItemsEqual(Document originalDoc, Document doc) throws IOException, ParserConfigurationException, SAXException {
        XPath xPath = new XPath("//item");
        Element originalElement = originalDoc.getElement((IXPath)xPath);
        Element element = doc.getElement((IXPath)xPath);
        element.removeElement("project");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/created"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/updated"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/resolved"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/due"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/comments/comment"), "created");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/attachments/attachment"), "created");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/customfields/customfield[@key='com.atlassian.jira.plugin.system.customfieldtypes:datetime']/customfieldvalues/customfieldvalue"), null);
        originalElement.getElement("link").getText().setData(this.changeUrl(this.tester.getTestContext().getBaseUrl(), originalElement.getElement("link").getText().getData()));
        originalElement.getElement("type").setAttribute("iconUrl", this.changeUrl(this.tester.getTestContext().getBaseUrl(), originalElement.getElement("type").getAttribute("iconUrl")));
        originalElement.getElement("priority").setAttribute("iconUrl", this.changeUrl(this.tester.getTestContext().getBaseUrl(), originalElement.getElement("priority").getAttribute("iconUrl")));
        originalElement.getElement("status").setAttribute("iconUrl", this.changeUrl(this.tester.getTestContext().getBaseUrl(), originalElement.getElement("status").getAttribute("iconUrl")));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLAssert.assertXMLEqual((String)originalElement.toString(), (String)element.toString());
    }

    private void removeTimeZoneFromElementValue(Document originalDocument, Document document, XPath xPathToElement, String attributeName) {
        Elements originalElements = originalDocument.getElements((IXPath)xPathToElement);
        Elements elements = document.getElements((IXPath)xPathToElement);
        if (originalElements != null && elements != null) {
            while (originalElements.hasMoreElements() && elements.hasMoreElements()) {
                if (attributeName == null) {
                    this.removeTimeZoneFromElementValue(originalElements.next());
                    this.removeTimeZoneFromElementValue(elements.next());
                    continue;
                }
                this.removeTimeZoneFromAttributeValue(originalElements.next(), attributeName);
                this.removeTimeZoneFromAttributeValue(elements.next(), attributeName);
            }
        }
    }

    private void removeTimeZoneFromElementValue(Element dateElement) {
        try {
            Date createdDate = this.dateFormat.parse(dateElement.getText().toString());
            dateElement.setText(this.dateFormat.format(createdDate));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeTimeZoneFromAttributeValue(Element dateElement, String attributeName) {
        try {
            Date createdDate = this.dateFormat.parse(dateElement.getAttribute(attributeName));
            dateElement.setAttribute(attributeName, this.dateFormat.format(createdDate));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertCommentHasDetailsOnRestrictingFields(Document doc, String xmlViewUrl) {
        this.logger.log((Object)"Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        Assert.assertNotNull((Object)commentNode);
        Assert.assertEquals((long)8L, (long)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        Assert.assertNotNull((Object)commentText);
        Assert.assertTrue((boolean)commentText.contains("RSS generated by JIRA"));
        Assert.assertTrue((boolean)commentText.contains("It is possible to restrict the fields that are returned in this document by specifying the 'field' parameter in your request.\nFor example, to request only the issue key and summary append 'field=key&field=summary' to the URL of your request."));
    }

    @Test
    public void testRegularView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    @Test
    public void testNoIssueLinksView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.backdoor.issueLinking().disable();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-issue-links-v813.xml");
        String xmlViewUrl = "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah";
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah");
    }

    @Test
    public void testNoTimetrackingView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.administration.timeTracking().disable();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-timetracking-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    @Test
    public void testTimetrackingHiddenView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.editIssueFieldVisibility.setHiddenFields("Time Tracking");
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-timetracking-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    @Test
    public void testHideDueDateFieldView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.editIssueFieldVisibility.setHiddenFields("Due Date");
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-due-date-hidden-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    @Test
    public void testNoCustomFieldsView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.removeAllCustomFields();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-custom-fields-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    @Test
    public void testNoSubtasksView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.navigation.issue().deleteIssue("HSP-3");
        this.backdoor.subtask().disable();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-subtasks-v813.xml");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public Document getComparisonDocument(String fileName) throws electric.xml.ParseException {
        return new Document(new File(this.getEnvironmentData().getXMLDataLocation(), fileName));
    }

    protected Document getDocument() throws IOException, electric.xml.ParseException {
        InputStream inputStream = this.tester.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }

    private void removeAllCustomFields() {
        List customFields = this.backdoor.customFields().getCustomFields();
        customFields.forEach(cfResponse -> this.backdoor.customFields().deleteCustomField(cfResponse.id));
    }
}

