/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.comments;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestCommentPermissions
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCommentPermissions.xml");
    }

    @Test
    public void testAdminCanEditAndDeleteAllComments() throws Exception {
        this.navigation.issue().viewIssue("RAT-2");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("Commented by Fred");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.assertLinkPresent("edit_comment_10000");
        this.tester.assertLinkPresent("delete_comment_10000");
        this.tester.assertLinkPresent("edit_comment_10001");
        this.tester.assertLinkPresent("delete_comment_10001");
        this.tester.assertLinkPresent("edit_comment_10002");
        this.tester.assertLinkPresent("delete_comment_10002");
        this.tester.clickLink("edit_comment_10001");
        this.tester.setWorkingForm("comment-edit");
        this.tester.setFormElement("comment", "admin can edit Fred's comment");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("admin can edit Fred&#39;s comment");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.clickLink("edit_comment_10002");
        this.tester.setWorkingForm("comment-edit");
        this.tester.setFormElement("comment", "admin can edit anonymous");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("admin can edit Fred&#39;s comment");
        this.tester.assertTextPresent("admin can edit anonymous");
        this.tester.clickLink("delete_comment_10001");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextNotPresent("admin can edit Fred&#39;s comment");
        this.tester.assertTextPresent("admin can edit anonymous");
        this.tester.clickLink("delete_comment_10002");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextNotPresent("admin can edit Fred&#39;s comment");
        this.tester.assertTextNotPresent("admin can edit anonymous");
    }

    @Test
    public void testCantEditOrDeleteCommentsInClosedIssues() throws Exception {
        this.navigation.issue().viewIssue("RAT-2");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("Commented by Fred");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.assertLinkPresent("edit_comment_10000");
        this.tester.assertLinkPresent("delete_comment_10000");
        this.tester.assertLinkPresent("edit_comment_10001");
        this.tester.assertLinkPresent("delete_comment_10001");
        this.tester.assertLinkPresent("edit_comment_10002");
        this.tester.assertLinkPresent("delete_comment_10002");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertLinkNotPresent("edit_comment_10000");
        this.tester.assertLinkNotPresent("delete_comment_10000");
        this.tester.assertLinkNotPresent("edit_comment_10001");
        this.tester.assertLinkNotPresent("delete_comment_10001");
        this.tester.assertLinkNotPresent("edit_comment_10002");
        this.tester.assertLinkNotPresent("delete_comment_10002");
    }

    @Test
    public void testFredCanEditAndDeleteOwnComments() throws Exception {
        this.navigation.login("fred");
        this.navigation.issue().viewIssue("RAT-2");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("Commented by Fred");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.assertLinkNotPresent("edit_comment_10000");
        this.tester.assertLinkNotPresent("delete_comment_10000");
        this.tester.assertLinkPresent("edit_comment_10001");
        this.tester.assertLinkPresent("delete_comment_10001");
        this.tester.assertLinkNotPresent("edit_comment_10002");
        this.tester.assertLinkNotPresent("delete_comment_10002");
        this.tester.clickLink("edit_comment_10001");
        this.tester.setWorkingForm("comment-edit");
        this.tester.setFormElement("comment", "Fred can edit Fred's comment");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("Fred can edit Fred&#39;s comment");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.clickLink("delete_comment_10001");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextNotPresent("Fred can edit Fred&#39;s comment");
        this.tester.assertTextPresent("Anonymous comment");
    }

    @Test
    public void testAnonCanEditAndDeleteNothing() throws Exception {
        this.navigation.logout();
        this.navigation.issue().viewIssue("RAT-2");
        this.tester.assertTextPresent("Commented by admin");
        this.tester.assertTextPresent("Commented by Fred");
        this.tester.assertTextPresent("Anonymous comment");
        this.tester.assertLinkNotPresent("edit_comment_10000");
        this.tester.assertLinkNotPresent("delete_comment_10000");
        this.tester.assertLinkNotPresent("edit_comment_10001");
        this.tester.assertLinkNotPresent("delete_comment_10001");
        this.tester.assertLinkNotPresent("edit_comment_10002");
        this.tester.assertLinkNotPresent("delete_comment_10002");
    }
}

