/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xss;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY})
@LoginAs(user="admin")
public class TestXssInCommentUserLink
extends BaseJiraFuncTest {
    private static final String XSS = "<script>alert('XSS');</script>";
    private static final String XSS_IN_REL = "rel=\"<script>alert('XSS');</script>\"";
    private static final String XSS_ESCAPED_IN_REL = "rel=\"&lt;script&gt;alert(&#39;XSS&#39;);&lt;/script&gt;\"";

    @Test
    public void testXssInUserLinks() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        this.backdoor.usersAndGroups().addUser(XSS);
        String issueKey = this.backdoor.issues().createIssue("HSP", "Testing XSS").key();
        this.backdoor.issues().commentIssue(issueKey, "[~<script>alert('XSS');</script>]");
        this.navigation.issue().gotoIssue(issueKey);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_IN_REL);
        this.assertions.getTextAssertions().assertTextPresent(XSS_ESCAPED_IN_REL);
    }
}

