/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAppMonitoringAnalytics
extends BaseJiraFuncTest {
    @Test
    @EnableAnalytics
    public void testTogglingAppMonitoring_shouldFireAnAnalyticEvent() {
        boolean initiallyEnabled = this.getBackdoor().profiling().isAppMonitoringEnabled();
        if (initiallyEnabled) {
            this.getBackdoor().profiling().disableAppMonitoring();
        } else {
            this.getBackdoor().profiling().enableAppMonitoring();
        }
        boolean newEnabledState = !initiallyEnabled;
        Assert.assertEquals((Object)newEnabledState, (Object)this.getBackdoor().profiling().isAppMonitoringEnabled());
        Map<String, ?> eventProperties = this.awaitFirstAnalyticsEvent("jira.monitoring.app.toggled");
        MatcherAssert.assertThat(eventProperties, (Matcher)Matchers.hasEntry((Object)"analyticEventVersion", (Object)2));
        MatcherAssert.assertThat(eventProperties, (Matcher)Matchers.hasEntry((Object)"isAppMonitoringEnabled", (Object)newEnabledState));
    }

    private Map<String, ?> awaitFirstAnalyticsEvent(String name) {
        return (Map)Awaitility.await().timeout(Duration.TWO_MINUTES).until(() -> this.backdoor.analyticsEventsControl().matchEvents(name).stream().map(event -> (Map)event.get("properties")).findFirst().orElse(null), Matchers.notNullValue());
    }

    private String getBaseUrl() {
        return this.environmentData.getBaseUrl().toExternalForm();
    }
}

