/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import com.jayway.awaitility.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestCommentReIndexJmxMetrics
extends BaseJmxMetricsTest {
    private static final String ISSUE_INDEXING_SERVICE_OPERATION = "ISSUE_INDEXING_SERVICE";
    private static final String ISSUE_INDEX_MANAGER_OPERATION = "ISSUE_INDEX_MANAGER";
    private static final String EXPECTED_JMX_TIMER_METRIC = "com.atlassian.jira:category00=comment,name=reindexing,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin,type=metrics";
    private static final String EXPECTED_JMX_LONG_RUNNING_TIMER_METRIC = "com.atlassian.jira:category00=comment,name=reindexing,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin,tag.statistic=active,tag.subCategory=current,type=metrics";
    private static final Duration METRICS_TIMEOUT = new Duration(3L, TimeUnit.SECONDS);
    private static final String PROJECT_KEY = "HSP";
    @Rule
    public final BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);

    @Before
    public void setup() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "foo blah blah blah");
        this.backdoor.issues().commentIssue(issue.key, "yabba dabba boo bar bing");
    }

    @Test
    @EnableAnalytics
    public void commentReIndexWithIndexingService_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(ISSUE_INDEXING_SERVICE_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"comment.reindexing"), (Matcher)Matchers.hasEntry((Object)"tags.invokerPluginKey", (Object)"com.atlassian.diagnostics.noisy-neighbour-jira-plugin"), (Matcher)Matchers.hasEntry((Object)"count", (Object)1));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    @EnableAnalytics
    public void commentReIndexWithIndexManager_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(ISSUE_INDEX_MANAGER_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"comment.reindexing"), (Matcher)Matchers.hasEntry((Object)"tags.invokerPluginKey", (Object)"com.atlassian.diagnostics.noisy-neighbour-jira-plugin"), (Matcher)Matchers.hasEntry((Object)"count", (Object)1));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    public void commentReIndexWithIndexingService_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(ISSUE_INDEXING_SERVICE_OPERATION);
        this.waitUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            return jmxBeans.contains(EXPECTED_JMX_TIMER_METRIC) && jmxBeans.contains(EXPECTED_JMX_LONG_RUNNING_TIMER_METRIC);
        }, METRICS_TIMEOUT);
    }

    @Test
    public void commentReIndexWithIndexManager_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(ISSUE_INDEX_MANAGER_OPERATION);
        this.waitUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            return jmxBeans.contains(EXPECTED_JMX_TIMER_METRIC) && jmxBeans.contains(EXPECTED_JMX_LONG_RUNNING_TIMER_METRIC);
        }, METRICS_TIMEOUT);
    }
}

