/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestJiraCoreDatabaseMetrics
extends BaseJmxMetricsTest {
    private static final String DB_CORE_EXECUTION_TIME_METRIC_NAME = "db.core.executionTime";
    private static final String BASIC_QUERY_USING_OFBIZ_CONNECTION_FACTORY_OPERATION_KEY = "CON_FACTORY_BASIC";
    private static final String BASIC_QUERY_USING_DB_ACCESSOR_OPERATION_KEY = "DATABASE_ACCESSOR_BASIC";
    private static final String SQL_OPTIONAL_TAG_KEY = "sql";
    @Rule
    public final BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);

    @Ignore(value="https://bulldog.internal.atlassian.com/browse/ITASM2-361 Behind a feature flag")
    @Test
    public void testAccessingTheDbThroughStaticMethods_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(BASIC_QUERY_USING_OFBIZ_CONNECTION_FACTORY_OPERATION_KEY);
        this.tryAssertUntil(() -> TestJiraCoreDatabaseMetrics.assertThatTheTimerAndLongRunningTimerMetricsArePresent(this.getJmxBeans(), "com.atlassian.jira:category00=db,category01=core,name=executionTime,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-plugin"));
    }

    @Test
    public void testAccessingTheDbThroughAnOSGiService_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(BASIC_QUERY_USING_DB_ACCESSOR_OPERATION_KEY);
        this.tryAssertUntil(() -> TestJiraCoreDatabaseMetrics.assertThatTheTimerAndLongRunningTimerMetricsArePresent(this.getJmxBeans(), "com.atlassian.jira:category00=db,category01=core,name=executionTime,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin"));
    }

    @Test
    public void testEnablingTheOptionalSqlTag_shouldPutItInTheJmxOutput() {
        this.jmxNoisyNeighbourRule.enableOptionalField(DB_CORE_EXECUTION_TIME_METRIC_NAME, SQL_OPTIONAL_TAG_KEY);
        this.startNoisyNeighbourOperation(BASIC_QUERY_USING_OFBIZ_CONNECTION_FACTORY_OPERATION_KEY);
        this.tryAssertUntil(() -> MatcherAssert.assertThat(this.getJmxBeans(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.containsString((String)"tag.sql=SELECT_TOP_0_0_COL_NAME"))));
    }

    @Test
    @EnableAnalytics
    public void testCoreDatabaseMetrics_shouldBeSentToAnalytics_withoutPersonallyIdentifiableInformation() {
        this.jmxNoisyNeighbourRule.enableOptionalField(DB_CORE_EXECUTION_TIME_METRIC_NAME, SQL_OPTIONAL_TAG_KEY);
        this.startNoisyNeighbourOperation(BASIC_QUERY_USING_OFBIZ_CONNECTION_FACTORY_OPERATION_KEY);
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)Matchers.allOf((Matcher)Matchers.hasKey((Object)"count"), (Matcher)Matchers.hasEntry((Object)"name", (Object)DB_CORE_EXECUTION_TIME_METRIC_NAME), (Matcher)Matchers.hasEntry((Object)"type", (Object)"timer"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)SQL_OPTIONAL_TAG_KEY))));
    }

    private static void assertThatTheTimerAndLongRunningTimerMetricsArePresent(List<String> jmxMBeans, String normalTimerName) {
        MatcherAssert.assertThat((String)"The regular timer metrics should be present", jmxMBeans, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)normalTimerName)));
        MatcherAssert.assertThat((String)"The long running timer's number of active timers metric should be present", jmxMBeans, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)(normalTimerName + ",tag.statistic=active,tag.subCategory=current,"))));
        MatcherAssert.assertThat((String)"The long running timer's most recent duration metric should be present", jmxMBeans, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)(normalTimerName + ",tag.statistic=max,tag.subCategory=current"))));
        MatcherAssert.assertThat((String)"The long running timer's active maximum duration should be present", jmxMBeans, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)(normalTimerName + ",tag.statistic=duration,tag.subCategory=current"))));
    }
}

