/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestAnnouncementBanner
extends BaseJiraFuncTest {
    private static final String ANNOUNCEMENT = "<p>JIRA 3.4 IS NOW INSTALLED <a href=\"http://confluence.atlassian.com/display/JIRA/JIRA+3.4+and+3.4.1+Release%20Notes\" target=\"_blank\">Review Release Notes Here</a></p>";
    @Inject
    private LocatorFactory locator;

    @Test
    public void testAnnouncementBanner() {
        try {
            this.setBannerText(ANNOUNCEMENT);
        }
        finally {
            this.clearBannerText();
        }
    }

    @Test
    public void testAnnouncementBannerDoesNotShowInPrivateModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(false);
            this.navigation.logout();
            this.tester.beginAt("/secure/Dashboard.jspa");
            this.tester.assertTextNotPresent(ANNOUNCEMENT);
        }
        finally {
            this.navigation.login("admin", "admin");
            this.clearBannerText();
        }
    }

    @Test
    public void testAnnouncementBannerShownInPublicModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(true);
            this.navigation.logout();
            this.tester.beginAt("/secure/Dashboard.jspa");
            this.tester.assertTextPresent(ANNOUNCEMENT);
        }
        finally {
            this.navigation.login("admin", "admin");
            this.clearBannerText();
        }
    }

    private void setJIRAModePublic(boolean publicMode) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.selectOption("mode", publicMode ? "Public" : "Private");
        this.tester.submit();
    }

    protected void setBannerDisplayMode(boolean isPublic) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EDIT_ANNOUNCEMENT);
        this.tester.setWorkingForm("announcementbanner-edit");
        if (isPublic) {
            this.tester.checkCheckbox("bannerVisibility", "public");
        } else {
            this.tester.checkCheckbox("bannerVisibility", "private");
        }
        this.tester.submit();
    }

    protected void clearBannerText() {
        this.gotoBannerPage();
        this.tester.setWorkingForm("announcementbanner-edit");
        this.tester.setFormElement("announcement", "");
        this.tester.submit();
    }

    protected void setBannerText(String bannerText) {
        this.gotoBannerPage();
        this.tester.setWorkingForm("announcementbanner-edit");
        this.tester.setFormElement("announcement", bannerText);
        this.tester.submit();
        CssLocator css = this.locator.css(".alertHeader");
        Assert.assertTrue((boolean)css.getHTML().contains(bannerText));
    }

    protected void gotoBannerPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EDIT_ANNOUNCEMENT);
    }
}

