/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.SkipSetBaseUrl;
import com.atlassian.jira.functest.framework.SkipSetup;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.google.common.collect.Iterables;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SETUP, Category.DATABASE, Category.TPM, Category.IPV6})
@SkipSetup
@SkipCacheCheck
@SkipSetBaseUrl
public class TestIPv6DatabaseSetup
extends BaseJiraFuncTest {
    @Inject
    private FuncTestRestClient restClient;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAll() throws IOException, SAXException, JSONException {
        if (this.getEnvironmentData().getProperty("databaseType") != null) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            this._testDirectJdbcSuccessful();
            this.configureDirectJdbc();
        } else {
            this.logger.log((Object)"Skipping TestDatabaseSetup: Internal DB configured.");
        }
    }

    private void configureDirectJdbc() {
        this.navigation.gotoPage("/secure/SetupDatabase!default.jspa");
        JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.getEnvironmentData());
        this.textAssertions.assertTextPresent(this.locator.page(), "Set up application properties");
    }

    private void _testDirectJdbcSuccessful() throws IOException, SAXException, JSONException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        this.assertTestConnectionSuccessful(query);
    }

    private Map<String, String> fillValidDirectJdbcValues() throws IOException, SAXException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("databaseOption", "external");
        query.put("databaseType", this.getEnvironmentData().getProperty("databaseType"));
        query.put("jdbcHostname", this.getEnvironmentData().getProperty("db.host"));
        query.put("jdbcPort", this.getEnvironmentData().getProperty("db.port"));
        query.put("jdbcSid", this.getEnvironmentData().getProperty("db.instance"));
        query.put("jdbcDatabase", this.getEnvironmentData().getProperty("db.instance"));
        query.put("jdbcUsername", this.getEnvironmentData().getProperty("username"));
        query.put("jdbcPassword", this.getEnvironmentData().getProperty("password"));
        query.put("schemaName", this.getEnvironmentData().getProperty("schema-name"));
        return query;
    }

    private void assertTestConnectionSuccessful(Map<String, String> query) throws IOException, SAXException, JSONException {
        Assert.assertTrue((boolean)new JSONObject(this.testConnection(query)).getJSONObject("data").getBoolean("dbTestSuccessful"));
    }

    private String testConnection(Map<String, String> query) throws IOException, SAXException {
        WebResponse response = this.restClient.GET("/secure/SetupDatabase!connectionCheck.jspa?" + this.toQueryString(query));
        return response.getText();
    }

    private String toQueryString(Map<String, String> query) {
        return StringUtils.join((Iterable)Iterables.transform(query.entrySet(), entry -> (String)entry.getKey() + "=" + (String)entry.getValue()), (char)'&');
    }
}

