/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestRememberMeCookie
extends BaseJiraFuncTest {
    private static final String USER_LAGONIL = "lagonil";
    private static final String SERAPH_REMEMBERME_COOKIE = "seraph.rememberme.cookie";
    @Inject
    private Administration administration;

    @Test
    public void testRememberMeCookieWorks() {
        this.administration.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser(USER_LAGONIL);
        this.navigation.login(USER_LAGONIL, USER_LAGONIL, true);
        this.tester.assertLinkPresent("find_link");
        Assert.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        Assert.assertEquals((Object)this.navigation.userProfile().userName(), (Object)USER_LAGONIL);
        String seraphCookie = this.tester.getDialog().getWebClient().getCookieValue(SERAPH_REMEMBERME_COOKIE);
        Assert.assertNotNull((String)"Didnt find cookie as expected", (Object)seraphCookie);
        Assert.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (boolean)seraphCookie.contains(">"));
        Assert.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (boolean)seraphCookie.contains("<"));
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkNotPresent("find_link");
        Assert.assertFalse((boolean)this.navigation.userProfile().link().isPresent());
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getDialog().getWebClient().addCookie(SERAPH_REMEMBERME_COOKIE, seraphCookie);
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresent("find_link");
        Assert.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        Assert.assertEquals((Object)this.navigation.userProfile().userName(), (Object)USER_LAGONIL);
    }
}

