/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSE_PROJECT, Category.COMMENTS, Category.DASHBOARDS, Category.ISSUE_NAVIGATOR, Category.ISSUES, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestReplacedLocalVelocityMacros
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestReplacedLocalVelocityMacros.xml");
    }

    @Test
    public void testEditCommentDropDownBoxViewableBy() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.assertFormElementPresent("commentLevel");
        this.tester.assertOptionsEqual("commentLevel", new String[]{"All Users", "jira-administrators", "jira-developers", "jira-users"});
    }

    @Test
    public void testWorklogTab() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Work Log");
        this.tester.assertLinkPresentWithText("Administrator");
        this.tester.assertLinkPresent("worklogauthor_10000");
        this.tester.assertTextPresent("logged work  -");
        this.tester.assertTextPresent("2 hours");
    }

    @Test
    public void testPrintableIssueView() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Printable");
        this.tester.assertTextPresent("The banana&#39;s are gone...");
        this.tester.assertTextPresent("duplicates");
        this.tester.assertTextPresent("Duplicate");
        this.tester.assertLinkPresentWithText("New Version 1");
    }

    @Test
    public void testXMLIssueView() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("XML");
        this.tester.assertTextPresent("Someone stole the monkey&apos;s banana  &amp;  OOOHH NOOO");
        this.tester.assertTextPresent("<description>Bring the monkey&amp;#39;s banana back!&lt;br/&gt;\n&lt;br/&gt;\nOtherwise he will start to swear:&amp;#39;&amp;amp;@#$%^*()&amp;#39;</description>");
        this.tester.assertTextPresent("<issuelink>");
        this.tester.assertTextPresent("<issuekey id=\"10010\">HSP-2</issuekey>");
        this.tester.assertTextPresent("</issuelink>");
        this.tester.gotoPage("si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml?rssMode=raw");
        this.tester.assertTextPresent("Someone stole the monkey&apos;s banana  &amp;  OOOHH NOOO");
        this.tester.assertTextPresent("<description><![CDATA[Bring the monkey's banana back!\n\nOtherwise he will start to swear:'&@#$%^*()']]></description>");
        this.tester.assertTextPresent("<issuelink>");
        this.tester.assertTextPresent("<issuekey id=\"10010\">HSP-2</issuekey>");
        this.tester.assertTextPresent("</issuelink>");
    }

    @Test
    public void testWikiMarkupHelp() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.clickLink("viewHelp");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "h2"), "Text Effects");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "th"), "Notation");
        this.tester.assertTextPresent("aui-nav-selected");
    }

    @Test
    public void testRSSCommentAllIssues() {
        this.navigation.issueNavigator().displayRssAllComments();
        this.tester.dumpResponse();
        this.tester.assertTextPresent("issues/?jql=");
        this.tester.assertTextPresent("<title>RE: [HSP-1] Someone stole the monkey&apos;s banana  &amp;  OOOHH NOOO</title>");
    }

    @Test
    public void testRSSViewAllIssues() {
        this.navigation.issueNavigator().displayRssAllIssues();
        this.tester.assertTextPresent("issues/?jql=");
        this.tester.assertTextPresent("<title>[HSP-1] Someone stole the monkey&apos;s banana  &amp;  OOOHH NOOO</title>");
        this.tester.assertTextPresent("<title>[HSP-2] The banana&apos;s are gone...</title>");
    }

    @Test
    public void testXMLViewAllIssues() {
        this.navigation.issueNavigator().displayXmlAllIssues();
        this.tester.assertTextPresent("issues/?jql=");
    }
}

