/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.JiraMode;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestSignup
extends BaseJiraFuncTest {
    private static final String AUTHENTICATION_ERROR_MSG = "Sorry, your username and password are incorrect - please try again.";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.generalConfiguration().setContactAdminFormOn();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
    }

    @Test
    public void checkWhetherJiraRequestTimingInfoIsWrittenIntoHtml() {
        this.navigation.gotoPage("login.jsp");
        this.assertions.assertNodeDoesNotExist(this.locator.id("jira_request_timing_info"));
    }

    @Test
    public void testSignupLinkNotPresentIfJiraNotPublic() throws Exception {
        boolean enabled = true;
        this.enablePublicMode(true);
        this.navigation.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
        this.navigation.login("admin", "admin");
        enabled = false;
        this.enablePublicMode(false);
        this.navigation.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
        this.navigation.login("admin", "admin");
        enabled = true;
        this.enablePublicMode(true);
        this.navigation.logout();
        this.assertMessageOnLoginPage(enabled);
        this.assertMessageOnBrowseProjects(enabled);
        this.assertMessageOnViewProjects(enabled);
    }

    @Test
    public void testSignupLinkNotPresentIfJiraNotPublicEditIssue() throws Exception {
        this.administration.project().addProject("Test", "TST", "admin");
        String issueKey = this.navigation.issue().createIssue("Test", "Bug", "Nam lobortis; nulla et sollicitudin");
        String issueId = this.navigation.issue().getId(issueKey);
        boolean enabled = true;
        this.enablePublicMode(true);
        this.navigation.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
        this.navigation.login("admin", "admin");
        enabled = false;
        this.enablePublicMode(false);
        this.navigation.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
        this.navigation.login("admin", "admin");
        enabled = true;
        this.enablePublicMode(true);
        this.navigation.logout();
        this.assertMessageOnEditIssue(enabled, issueId);
    }

    private void assertMessageOnLoginPage(boolean publicModeEnabled) {
        this.navigation.gotoPage("login.jsp");
        if (publicModeEnabled) {
            this.textAssertions.assertTextSequence(this.signUpHintLocator(), new String[]{"Not a member?", "Sign up", "for an account."});
            this.textAssertions.assertTextNotPresent(this.signUpHintLocator(), "to request an account.");
            this.assertions.link().assertLinkByIdHasExactText("signup", "Sign up");
        } else {
            this.textAssertions.assertTextNotPresent(this.signUpHintLocator(), "for an account");
            this.textAssertions.assertTextSequence(this.signUpHintLocator(), new String[]{"Not a member?", "To request an account, please contact your", "Jira administrators"});
            this.assertions.link().assertLinkPresentWithExactTextById(this.signUpHintSectionId(), "Jira administrators");
        }
    }

    private Locator signUpHintLocator() {
        return this.locator.id(this.signUpHintSectionId());
    }

    private String signUpHintSectionId() {
        return "sign-up-hint";
    }

    private void assertMessageOnEditIssue(boolean enabled, String issueId) {
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        if (enabled) {
            this.assertions.forms().assertFormErrMsg("You are not logged in, and do not have the permissions required to act on the selected issue as a guest.");
            this.assertions.forms().assertFormErrMsg("log in or sign up for an account.");
            this.assertions.forms().assertFormErrMsgContainsLink("log in");
            this.assertions.forms().assertFormErrMsgContainsLink("sign up");
        } else {
            this.assertions.getJiraFormAssertions().assertNoFormErrMsg("for an account");
        }
    }

    private void assertMessageOnBrowseProjects(boolean enabled) {
        this.tester.gotoPage("/secure/project/BrowseProjects.jspa");
        if (enabled) {
            this.tester.assertTextPresent("for an account to browse projects.");
            this.tester.assertLinkPresentWithText("Log in");
            this.tester.assertLinkPresentWithText("sign up");
        } else {
            this.tester.assertTextNotPresent("for an account.");
        }
    }

    private void assertMessageOnViewProjects(boolean publicModeEnabled) {
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
        if (publicModeEnabled) {
            this.assertions.forms().assertFormWarningMessage("If you log in or sign up for an account, you might be able to see more here.");
            this.assertions.forms().assertFormWarningMessage("sign up");
        } else {
            this.assertions.forms().assertNoFormWarningMessage("for an account, you might be able to see more here.");
        }
    }

    private void enablePublicMode(boolean enablePublicMode) {
        this.backdoor.generalConfiguration().setJiraMode(JiraMode.forPublicModeEnabledValue((boolean)enablePublicMode));
    }

    @Test
    public void testEnableCaptcha() {
        this.toggleCaptcha(true);
        this.navigation.logout();
        this.tester.beginAt("/captcha");
        this.tester.beginAt("/");
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertFormElementPresent("captcha");
        this.tester.setFormElement("username", "test");
        this.tester.setFormElement("fullname", "test");
        this.tester.setFormElement("email", "test@test.com");
        this.tester.setFormElement("captcha", "");
        this.tester.submit();
        this.tester.assertTextPresent("Please enter the word as shown below");
    }

    @Test
    public void testDisableCaptcha() {
        this.toggleCaptcha(false);
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertFormElementNotPresent("captcha");
        this.tester.setFormElement("username", "test");
        this.tester.setFormElement("fullname", "test");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "test@test.com");
        this.tester.submit();
        this.tester.assertTextNotPresent("You must enter the text exactly as it appears in the picture.");
        this.tester.assertTextPresent("You have successfully signed up.");
    }

    @Test
    public void testStayInTouchLink() {
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "test");
        this.tester.setFormElement("fullname", "test");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "test@test.com");
        this.tester.submit();
        this.tester.assertTextPresent("Stay connected with Atlassian. Subscribe to");
        this.assertions.link().assertLinkWithExactTextAndUrlPresent("blogs, newsletters, forums and more", "http://www.atlassian.com/about/connected.jsp?s_kwcid=jira-stayintouch");
    }

    private void toggleCaptcha(boolean enableCaptcha) {
        this.backdoor.generalConfiguration().toggleCaptchaOnSignup(enableCaptcha);
    }

    private void prepareToSignUp() {
        this.navigation.logout();
        this.gotoSignupPage();
        this.assertions.assertNodeHasText(this.locator.css("h2"), "Sign up");
        this.tester.setWorkingForm("signup");
        this.tester.assertButtonPresent("signup-submit");
    }

    private void gotoSignupPage() {
        this.tester.gotoPage("/secure/Signup!default.jspa");
    }

    @Test
    public void testMustBeLoggedOutToSignUp() {
        this.gotoSignupPage();
        this.assertions.assertNodeHasText(this.locator.css("h2"), "You're already logged in");
        this.assertions.assertNodeDoesNotExist(this.locator.id("signup-submit"));
        this.textAssertions.assertTextSequence(this.locator.page(), new String[]{"You can't sign up while logged in. Please", "log out", "first."});
        this.tester.assertLinkPresent("log_out");
    }

    @Test
    public void testEmptyData() {
        this.prepareToSignUp();
        this.tester.setFormElement("username", "");
        this.tester.setFormElement("fullname", "");
        this.tester.setFormElement("email", "");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a username.");
        this.tester.assertTextPresent("You must specify a password.");
        this.tester.assertTextPresent("You must specify a full name.");
        this.tester.assertTextPresent("You must specify an email address.");
    }

    @Test
    public void testNoPasswordSet() {
        this.prepareToSignUp();
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a password.");
        this.tester.assertTextNotPresent("You must specify a username.");
        this.tester.assertTextNotPresent("You must specify a full name.");
        this.tester.assertTextNotPresent("You must specify an email address.");
    }

    @Test
    public void testSignUpDuplicateUser() {
        this.checkSuccessUserCreate();
        this.prepareToSignUp();
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("A user with that username already exists.");
    }

    @Test
    public void testCreateUserSuccess() {
        this.checkSuccessUserCreate();
    }

    private void checkSuccessUserCreate() {
        this.prepareToSignUp();
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit();
        this.assertions.assertNodeHasText(this.locator.css("h2"), "Congratulations!");
        this.assertions.assertNodeHasText(this.locator.css("#content .aui-message.aui-message-success"), "You have successfully signed up. If you forget your password, you can request a new one.");
    }

    @Test
    public void testCreateUserInvalidEmail() {
        this.prepareToSignUp();
        this.tester.setFormElement("username", "User");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user.email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    @Test
    public void testCreateUserInvalidUsername() {
        this.prepareToSignUp();
        this.tester.setFormElement("username", "bad<username>");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user.email.com");
        this.tester.submit();
        this.tester.assertTextPresent("Sign up");
        this.tester.assertTextPresent("The username must not contain &#39;&lt;&#39;, &#39;&gt;&#39; or &#39;&amp;&#39;.");
    }

    @Test
    public void testCreateUserWIthLeadingOrTrailingSpaces() {
        this.prepareToSignUp();
        String untrimmedUserName = "   andres  ";
        this.tester.setFormElement("username", "   andres  ");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "user@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up.");
        this.navigation.loginAttempt("   andres  ", "password");
        this.tester.assertTextPresent(AUTHENTICATION_ERROR_MSG);
        this.navigation.loginAttempt("   andres  ".trim(), "password");
        this.tester.assertTextNotPresent(AUTHENTICATION_ERROR_MSG);
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/");
    }

    @Test
    public void testCreateUserFieldsExceed255() {
        this.prepareToSignUp();
        String username = StringUtils.repeat((String)"abcdefgh", (int)32);
        String fullname = StringUtils.repeat((String)"ABCDEFGH", (int)32);
        String email = StringUtils.repeat((String)"x", (int)246) + "@email.com";
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", fullname);
        this.tester.setFormElement("email", email);
        this.tester.submit();
        this.tester.assertTextPresent("The username must not exceed 255 characters in length.");
        this.tester.assertTextPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextPresent("The email address must not exceed 255 characters in length.");
        this.tester.setFormElement("username", username.substring(0, 255));
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", fullname.substring(0, 255));
        this.tester.setFormElement("email", email.substring(0, 255));
        this.tester.submit();
        this.tester.assertTextNotPresent("The username must not exceed 255 characters in length.");
        this.tester.assertTextNotPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextNotPresent("The email address must not exceed 255 characters in length.");
        this.navigation.login(username.substring(0, 255), "password");
        this.tester.assertTextPresent(fullname.substring(0, 255));
    }
}

