/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebForm;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestXSSInFullName
extends BaseJiraFuncTest {
    public static final String ALANS_PASSWORD = "alans";
    private static final String FULLNAME = "Alan <script>alert('I am a script')</script> Sapinsly";
    private static final String ESCAPED_FULLNAME = "Alan &lt;script&gt;alert(&#39;I am a script&#39;)&lt;/script&gt; Sapinsly";
    private static final String TEST_PROJECT = "Test";
    private static final String NEW_PROJECT = "New Project";
    private static final String ALANS_USERNAME = "alans";
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.navigation.login("admin", "admin");
        this.navigation.comment().enableCommentGroupVisibility(Boolean.TRUE);
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @Restore(value="TestXSSData.xml")
    @Test
    public void testFullNameWithScript() {
        this._testFullUsernameInComment();
        this._testEditAssigneeField();
        this._testAssigneeNavigatorView();
        this._testAssigneeFieldinMoveOperation();
        this._testChangeHistoryTab();
        this._testDeveloperWorkloadReport();
        this._testWorklogTab();
        this._testUserPickerCustomField();
        this._testReporterInNavigatorView();
        this._testWatchersTable();
        this._testDashboardPortlets();
        this._testReporterInBulkEdit();
        this._testMultiUserCustomFieldView();
        this._testTimeTrackingExcel();
    }

    public void _testFullUsernameInComment() {
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("footer-comment-button");
        this.tester.setWorkingForm("comment-add");
        this.tester.setFormElement("comment", "Testing scripting error");
        this.tester.submit("Add");
        this.checkName();
        this.textAssertions.assertTextPresent("Testing scripting error");
    }

    public void _testEditAssigneeField() {
        this.navigation.issue().goToCreateIssueForm(NEW_PROJECT, null);
        this.checkName();
    }

    public void _testAssigneeNavigatorView() {
        this.createIssue(NEW_PROJECT);
        this.tester.clickLink("find_link");
        this.checkName();
    }

    public void _testAssigneeFieldinMoveOperation() {
        this.createIssue(TEST_PROJECT);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject(NEW_PROJECT);
        this.tester.submit("Next >>");
        this.checkName();
    }

    public void _testChangeHistoryTab() {
        this.createIssue(TEST_PROJECT);
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().gotoIssue("TST-1");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.clickLinkWithText("History");
        this.checkName();
    }

    public void _testDeveloperWorkloadReport() {
        this.navigation.issue().goToCreateIssueForm(NEW_PROJECT, null);
        this.tester.setFormElement("summary", TEST_PROJECT);
        this.tester.setFormElement("timetracking", "1h");
        this.tester.submit("Create");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", "alans");
        this.tester.submit("Next");
        this.checkName();
    }

    public void _testWorklogTab() {
        this.navigation.issue().goToCreateIssueForm(NEW_PROJECT, null);
        this.tester.setFormElement("summary", TEST_PROJECT);
        this.tester.setFormElement("timetracking", "1h");
        this.tester.submit("Create");
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.submit();
        this.tester.clickLinkWithText("Work Log");
        this.checkName();
    }

    public void _testUserPickerCustomField() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", TEST_PROJECT);
        this.tester.setFormElement("customfield_10000", "alans");
        this.tester.submit("Create");
        this.checkName();
    }

    public void _testReporterInNavigatorView() {
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.createIssue(TEST_PROJECT);
        this.tester.clickLink("find_link");
        this.checkName();
    }

    public void _testWatchersTable() {
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().gotoIssue("TST-1");
        if (!this.tester.getDialog().isLinkPresent("toggle-unwatch-issue")) {
            this.tester.clickLink("toggle-watch-issue");
        }
        this.tester.clickLink("view-watcher-list");
        this.checkName();
    }

    public void _testDashboardPortlets() {
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", TEST_PROJECT);
        this.tester.setFormElement("customfield_10000", "alans");
        this.tester.submit("Create");
        this.tester.clickLink("home_link");
        this.checkName();
    }

    public void _testReporterInBulkEdit() {
        String[] parameterNames;
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.tester.clickLink("find_link");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.setWorkingForm("bulkedit");
        WebForm form = this.tester.getDialog().getForm();
        for (String name : parameterNames = form.getParameterNames()) {
            if (!name.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(name);
        }
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "reporter");
        this.tester.setFormElement("reporter", "alans");
        this.tester.submit("Next");
        this.checkName();
    }

    public void _testMultiUserCustomFieldView() {
        this.navigation.issue().goToCreateIssueForm(TEST_PROJECT, null);
        this.tester.setFormElement("summary", "Bug 1");
        this.tester.setFormElement("customfield_10010", "alans");
        this.tester.submit("Create");
        this.checkName();
    }

    public void _testTimeTrackingExcel() {
        this.navigation.logout();
        this.navigation.login("alans", "alans");
        this.navigation.issue().goToCreateIssueForm(NEW_PROJECT, null);
        this.tester.setFormElement("summary", TEST_PROJECT);
        this.tester.setFormElement("timetracking", "1h");
        this.tester.submit("Create");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking");
        this.tester.submit("Next");
        this.tester.clickLinkWithText("Excel View");
        this.checkName();
    }

    private void createIssue(String projectKey) {
        this.navigation.issue().goToCreateIssueForm(projectKey, null);
        this.tester.setFormElement("summary", "Bug 1");
        this.tester.submit("Create");
    }

    private void checkName() {
        this.textAssertions.assertTextNotPresent(FULLNAME);
        this.textAssertions.assertTextPresent(ESCAPED_FULLNAME);
    }
}

