/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigator.ValueForRowAtColumnCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@LoginAs(user="admin")
public class TestCustomFieldsVisibilityOnIssueTable
extends BaseJiraFuncTest {
    private static final String ALL_ISSUES_IN_ALL_PROJECTS_JQL = "";
    @Inject
    private Administration administration;

    @Test
    public void testOldFieldValuesForCustomFieldsAreNotDisplayedOnIssueTableWhenCustomFieldIsNotVisibleAccordingToTheProjectFieldScheme() {
        this.restoreJiraWithAnIssueWithAValueOnACustomFieldThatItsHiddenAccordingToTheProjectFieldScheme();
        this.searchForAllIssues();
        this.assertCustomFieldColumnDoesNotShowOldValueForTheIssue();
    }

    private void restoreJiraWithAnIssueWithAValueOnACustomFieldThatItsHiddenAccordingToTheProjectFieldScheme() {
        this.administration.restoreDataAndLogin("CustomFieldHiddenOnProjectByFieldScheme.xml", "admin");
    }

    private void searchForAllIssues() {
        this.navigation.issueNavigator().createSearch(ALL_ISSUES_IN_ALL_PROJECTS_JQL);
    }

    private void assertCustomFieldColumnDoesNotShowOldValueForTheIssue() {
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(Arrays.asList(new ValueForRowAtColumnCondition(1, "Custom Field", null)));
    }
}

