/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.CsvMatcher;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.util.CsvUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueNavigatorCsvView
extends BaseJiraFuncTest {
    private static final String INWARD_ISSUE_LINK_COLUMN_PREFIX = "Inward issue link";
    private static final String EXPORT_USER = "export_user";
    private static final String EXPORT_USER_LOCALISED = "export_user_localised";
    private static final String EMPTY_PROJECT_KEY = "NEW";
    private static final Long EMPTY_PROJECT_ID = 10010L;
    private static final String JQL_ORDERING = "ORDER BY key ASC";
    private static final String ADMIN_USERNAME = "admin";
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.backdoor().darkFeatures().enableForSite("jira.export.csv.enabled");
    }

    @After
    public void tearDown() {
        this.backdoor.applicationProperties().setText("jira.search.views.max.limit", "1000");
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvView.xml")
    @BeforeBuildRule.BeforeBuild(buildNumber=810000)
    public void testIfAllFieldsExportIsTheSameAsModelFile() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String csvExportWithRemovedInwardIssueLinkColumns = CsvUtils.removeColumnsThatStartWith(csvExport, INWARD_ISSUE_LINK_COLUMN_PREFIX);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFields.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExportWithRemovedInwardIssueLinkColumns));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvView.xml")
    @SinceBuildRule.SinceBuild(buildNumber=810000)
    public void testIfAllFieldsExportIsTheSameAsModelFileFor810000BuildNumberTestData() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFields816000.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvView.xml")
    @SinceBuildRule.SinceBuild(buildNumber=77003)
    @BeforeBuildRule.BeforeBuild(buildNumber=810000)
    public void testIfColumnsAndValuesAreTranslated() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER_LOCALISED);
        String csvExportWithRemovedInwardIssueLinkColumns = CsvUtils.removeColumnsThatStartWith(csvExport, "Verkn\u00ef\u00bf\u00bdpfung zu eingehendem Vorgang");
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFieldsGerman.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExportWithRemovedInwardIssueLinkColumns));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvView.xml")
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    public void testIfColumnsAndValuesAreTranslatedFor814000BuildNumberTestData() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER_LOCALISED);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFieldsGerman816000.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewFeaturesDisabled.xml")
    @BeforeBuildRule.BeforeBuild(buildNumber=810000)
    public void testAllFieldsExportedWhenSomeFeaturesAreDisabled() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String csvExportWithRemovedInwardIssueLinkColumns = CsvUtils.removeColumnsThatStartWith(csvExport, INWARD_ISSUE_LINK_COLUMN_PREFIX);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFieldsFeaturesDisabled.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExportWithRemovedInwardIssueLinkColumns));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewFeaturesDisabled.xml")
    @SinceBuildRule.SinceBuild(buildNumber=810000)
    public void testAllFieldsExportedWhenSomeFeaturesAreDisabledFor810000BuildNumberTestData() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAllFieldsFeaturesDisabled816000.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewAnonymousExportIssues.xml")
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void testAnonymousUsersSeeIssueWithPermissionTo() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(null);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewAnonymousExportIssues.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvView.xml")
    public void testAnonymousUseDoesNotSeeAnyIssuesWithoutProperPermission() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(null);
        Assert.assertThat((Object)csvExport, (Matcher)Matchers.equalTo((Object)"\n"));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewEmptyProject.xml")
    public void testIssueWithSecurityNotShown() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY);
        Long issueSchemeId = this.backdoor.issueSecuritySchemesControl().createScheme("Some scheme", "description");
        Long levelId = this.backdoor.issueSecuritySchemesControl().addSecurityLevel(issueSchemeId.longValue(), "Internal", "Internal users only");
        this.backdoor.project().setIssueSecurityScheme(EMPTY_PROJECT_ID, issueSchemeId);
        IssueCreateResponse issueCreateResponse = this.backdoor.issues().createIssue(EMPTY_PROJECT_KEY, "This is a new issue");
        String csvExport = this.getCsvExportOfAllFields(null);
        Assert.assertThat((String)"Anonymous user should be able to see one issue exported", (Object)this.getNumberRows(csvExport), (Matcher)Matchers.equalTo((Object)1));
        this.backdoor.issues().setIssueFields(issueCreateResponse.key, new IssueFields().securityLevel(ResourceRef.withId((String)String.valueOf(levelId))));
        String newCsvExport = this.getCsvExportOfAllFields(null);
        Assert.assertThat((Object)newCsvExport, (Matcher)Matchers.equalTo((Object)"\n"));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewWithCustomField.xml")
    public void testCustomFieldWithNoExportImplementedGetsDefaultOutput() throws IOException {
        String csvExport = this.getCsvExportCurrentFields(ADMIN_USERNAME);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewWithCustomField.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewWithMoreThan1000Issues.xml")
    public void testDisableExportLimit() {
        this.backdoor.applicationProperties().setString("jira.search.views.max.limit", "-1");
        String export = this.getCsvExportOfAllFields(ADMIN_USERNAME);
        Assert.assertThat((Object)export.split("\n").length, (Matcher)Matchers.is((Object)1006));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewServiceDeskProject.zip")
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void testServiceDeskCommentsExport() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(ADMIN_USERNAME);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewServiceDeskProject.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewRestrictedComments.zip")
    @SinceBuildRule.SinceBuild(buildNumber=9100000)
    public void testRestrictedCommentsExport() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(ADMIN_USERNAME);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewRestrictedComments.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewInjectionProtection.xml")
    public void testCsvInjectionProtection() throws IOException {
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewInjectionProtection.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @Restore(value="TestIssueNavigatorCsvViewInjectionProtection.xml")
    public void testCsvInjectionProtectionDisabled() throws IOException {
        FeatureFlag CSV_EXPORT_INJECTION_PROTECTION = FeatureFlag.featureFlag((String)"com.atlassian.jira.security.csv.export.injection.protection");
        this.backdoor.darkFeatures().disableForSite(CSV_EXPORT_INJECTION_PROTECTION);
        String csvExport = this.getCsvExportOfAllFields(EXPORT_USER);
        String expectedCsv = this.getExportModelContent("TestIssueNavigatorCsvViewInjectionProtectionDisabled.csv");
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    private Integer getNumberRows(String csvExport) {
        return csvExport.split("\n").length - 1;
    }

    private String getCsvExportOfAllFields(String username) {
        String jql = JQL_ORDERING;
        return this.getCsvExportAllFieldsForJql(username, JQL_ORDERING);
    }

    private String getCsvExportAllFieldsForJql(String username, String jql) {
        return this.getExportRequestForJql(username, "searchrequest-csv-all-fields", jql);
    }

    private String getCsvExportCurrentFields(String username) {
        String jql = "";
        return this.getExportRequestForJql(username, "searchrequest-csv-current-fields", "");
    }

    private String getExportRequestForJql(String username, String type, String jql) {
        if (username != null) {
            this.navigation.login(username);
        } else {
            this.navigation.logout();
        }
        this.tester.gotoPage("/sr/jira.issueviews:" + type + "/temp/SearchRequest.csv?jqlQuery=" + URLEncoder.encode(jql).replace("+", "%20"));
        return this.replaceDates(this.tester.getDialog().getResponseText());
    }

    private String getExportModelContent(String filename) throws IOException {
        String filePath = this.environmentData.getXMLDataLocation().getPath() + System.getProperty("file.separator") + filename;
        String content = FileUtils.readFileToString((File)new File(filePath));
        return this.replaceDates(content.replaceAll("http://localhost:8090/jira", this.environmentData.getBaseUrl().toString()));
    }

    private String replaceDates(String text) {
        return text.replaceAll("\\d+/[^/]*/\\d+ \\d+:\\d+ (PM|AM)", "xx/Xxx/xx xx:xx XX");
    }
}

