/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestSearchXmlViewErrors
extends BaseJiraFuncTest {
    private static final String SAMPLE_PATH_MESSAGE_1 = "Invalid path format.";
    private static final String SAMPLE_PATH_MESSAGE_2 = "Path should be of format";
    private static final String SAMPLE_PATH_MESSAGE_3 = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml";
    private static final String SAMPLE_PATH_MESSAGE_4 = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?param1=abc";
    private static final String BAD_PLUGIN_MESSAGE = "Could not find any enabled plugin with key";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testMalformedUrls() throws Exception {
        this.assert400SamplePathMessage("/sr");
        this.assert400SamplePathMessage("/sr/");
        this.assert400SamplePathMessage("/sr/unknownplugin");
        this.assert400SamplePathMessage("/sr/unknownplugin/");
        this.assert400SamplePathMessage("/sr/unknownplugin/blah");
        this.assert400BadPlugin("/sr/unknownplugin/blah/", "unknownplugin");
    }

    private void assert400SamplePathMessage(String url) {
        this.assert400(url);
        this.textAssertions.assertTextSequence(this.locator.page(), SAMPLE_PATH_MESSAGE_1, SAMPLE_PATH_MESSAGE_2, SAMPLE_PATH_MESSAGE_3, SAMPLE_PATH_MESSAGE_4);
    }

    private void assert400BadPlugin(String url, String message) {
        this.assert400(url);
        this.textAssertions.assertTextSequence(this.locator.page(), BAD_PLUGIN_MESSAGE, message);
    }

    private void assert400(String url) {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        try {
            this.tester.gotoPage(url);
            WebResponse webResponse = this.tester.getDialog().getResponse();
            Assert.assertEquals((long)400L, (long)webResponse.getResponseCode());
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }
}

