/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@Restore(value="TestIssueNavigatorCommentsRSSView.xml")
public class TestIssueNavigatorCommentsRSSView
extends BaseJiraFuncTest {
    private List<String> homosapienIssueKeys = ImmutableList.of((Object)"HSP-10", (Object)"HSP-9", (Object)"HSP-8", (Object)"HSP-7", (Object)"HSP-6", (Object)"HSP-5", (Object)"HSP-4", (Object)"HSP-3", (Object)"HSP-2", (Object)"HSP-1");
    private List<String> monkeyIssueKeys = ImmutableList.of((Object)"MKY-10", (Object)"MKY-9", (Object)"MKY-8", (Object)"MKY-7", (Object)"MKY-6", (Object)"MKY-5", (Object)"MKY-4", (Object)"MKY-3", (Object)"MKY-2", (Object)"MKY-1");
    private XPathFactory factory = XPathFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LoginAs(user="fred")
    public void testIssueNavigatorCommentsRSSView() throws Exception {
        int responseCode;
        String monkeyKey;
        String hspKey;
        ArrayList<Comment> tempComment;
        String jqlQuery;
        int i;
        ImmutableList comments = ImmutableList.of((Object)new Comment("", "A comment from Fred", "Fred"), (Object)new Comment("", "I was here... - You not! :P", "Administrator"), (Object)new Comment("", "Again a comment for issue", "Administrator"), (Object)new Comment("", "Another comment for issue", "Administrator"), (Object)new Comment("", "A comment for issue", "Administrator")).asList();
        for (String homosapienIssueKey : this.homosapienIssueKeys) {
            this._executeCommentsRSSView("issue = \"" + homosapienIssueKey + "\"");
            this._verifyIssueComments((List<Comment>)comments);
        }
        for (String monkeyIssueKey : this.monkeyIssueKeys) {
            this._executeCommentsRSSView("issue = \"" + monkeyIssueKey + "\"");
            this._verifyIssueComments((List<Comment>)comments);
        }
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("affectedVersion IS EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("affectedVersion IS NOT EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("assignee IS NOT EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("component IS NOT EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("description IS NOT EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("environment IS NOT EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("fixVersion IS NOT EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("level IS NOT EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY");
        queries.add("originalEstimate IS NOT EMPTY AND reporter IS EMPTY");
        queries.add("reporter IS NOT EMPTY");
        Assert.assertEquals((long)this.homosapienIssueKeys.size(), (long)this.monkeyIssueKeys.size());
        for (i = 0; i < queries.size(); ++i) {
            jqlQuery = (String)queries.get(i);
            this._executeCommentsRSSView(jqlQuery);
            tempComment = new ArrayList<Comment>();
            hspKey = this.homosapienIssueKeys.get(this.homosapienIssueKeys.size() - i - 1);
            monkeyKey = this.monkeyIssueKeys.get(this.monkeyIssueKeys.size() - i - 1);
            tempComment.add(new Comment(hspKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(monkeyKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(hspKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(hspKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "A comment for issue", "Administrator"));
            this._verifyIssueComments(tempComment);
        }
        this.navigation.login("admin");
        for (i = 0; i < queries.size(); ++i) {
            jqlQuery = (String)queries.get(i);
            this._executeCommentsRSSView(jqlQuery);
            tempComment = new ArrayList();
            hspKey = this.homosapienIssueKeys.get(this.homosapienIssueKeys.size() - i - 1);
            monkeyKey = this.monkeyIssueKeys.get(this.monkeyIssueKeys.size() - i - 1);
            tempComment.add(new Comment(hspKey, "Not visible for Fred", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Not visible for Fred", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(monkeyKey, "A comment from Fred", "Fred"));
            tempComment.add(new Comment(hspKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "I was here... - You not! :P", "Administrator"));
            tempComment.add(new Comment(hspKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Again a comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "Another comment for issue", "Administrator"));
            tempComment.add(new Comment(hspKey, "A comment for issue", "Administrator"));
            tempComment.add(new Comment(monkeyKey, "A comment for issue", "Administrator"));
            this._verifyIssueComments(tempComment);
        }
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this._executeCommentsRSSView("sdfdsfBLJLSKJLSKJF");
            responseCode = this.tester.getDialog().getResponse().getResponseCode();
            Assert.assertEquals((long)400L, (long)responseCode);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this._executeCommentsRSSView("issue = \"BLJLSKJLSKJF\"");
            responseCode = this.tester.getDialog().getResponse().getResponseCode();
            Assert.assertEquals((long)400L, (long)responseCode);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    private void _verifyIssueComments(List<Comment> comments) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        String xpathExpr = "//rss/channel/item";
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XPath xpath = this.factory.newXPath();
        XPathExpression expr = xpath.compile("//rss/channel/item");
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        Assert.assertEquals((long)comments.size(), (long)nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Comment comment = comments.get(i);
            String issueKey = comment.getIssueKey();
            if (issueKey != null && issueKey.length() > 0) {
                Node titleNode = node.getChildNodes().item(1);
                String title = titleNode.getFirstChild().getNodeValue();
                Assert.assertEquals((String)("Incorrect issue key in title! Expected: " + issueKey + " Title:" + title), (Object)true, (Object)title.contains(issueKey));
            }
            Node authorNode = node.getChildNodes().item(7);
            String author = authorNode.getFirstChild().getNodeValue();
            Assert.assertEquals((String)("Incorrect Author. Expected: " + author), (Object)true, (Object)author.contains(comment.getAuthor()));
            Node descriptionNode = node.getChildNodes().item(9);
            String description = descriptionNode.getFirstChild().getNodeValue();
            Assert.assertEquals((String)"Incorrect comment (order)!", (Object)true, (Object)description.contains(comment.getDescription()));
        }
    }

    private void _executeCommentsRSSView(String jqlQuery) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(jqlQuery, "UTF-8");
        String url = "/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=" + encodedQuery + "&tempMax=1000";
        this.tester.gotoPage(url);
    }

    class Comment {
        private final String issueKey;
        private final String description;
        private final String author;

        Comment(String issueKey, String description, String author) {
            this.issueKey = issueKey;
            this.description = description;
            this.author = author;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

