/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@RestoreOnce(value="TestJqlReleasedVersionsFunctions.xml")
public class TestJqlSystemFunctions
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "fred");
    }

    @Test
    public void testLatestReleasedVersion() throws Exception {
        this.createSearchAndAssertIssues("fixVersion = latestReleasedVersion(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("affectedVersion = latestReleasedVersion(MKY)", "MKY-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(MKY)", "MKY-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(MK)", "MK-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(HSP)", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(hsp)", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(homosapien)", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(HOMOSAPIEN)", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(10000)", "NUMBER-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(monkey)", "MKY-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(MKY)", "MKY-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(MK)", "MK-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(10001)", "MKY-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion()", "NUMBER-1", "MKY-1", "MK-1", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(HSP, MKY)", "MKY-1", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(HSP, MKY, MK)", "MKY-1", "MK-1", "HSP-1");
        this.createSearchAndAssertIssues("VP = latestReleasedVersion(HSP, 10001)", "MKY-1", "HSP-1");
        this.navigation.issueNavigator().loadFilter(10020L);
        this.tester.assertTextPresent("VP = latestReleasedVersion(HSP)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.issueTableAssertions.assertSearchWithErrorForUser("fred", "VP = latestReleasedVersion(HSP)", "Could not resolve the project 'HSP' provided to function 'latestReleasedVersion'.");
    }

    @Test
    public void testAllUnreleasedVersions() throws Exception {
        this.createSearchAndAssertIssues("fixVersion in unreleasedVersions()", "NUMBER-1", "MKY-1", "MK-1", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("affectedVersion in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(HSP)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(hsp)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(homosapien)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(HOMOSAPIEN)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(10000)", "NUMBER-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(monkey)", "MKY-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(MK)", "MK-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(10001)", "MKY-2");
        this.navigation.issueNavigator().loadFilter(10010L);
        this.tester.assertTextPresent("VP in unreleasedVersions(HSP)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("fixVersion in unreleasedVersions()", "NUMBER-1", "MKY-1", "MK-1");
        this.createSearchAndAssertIssues("affectedVersion in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2");
        this.navigation.issueNavigator().loadFilter(10010L);
        this.tester.assertTextPresent("VP in unreleasedVersions(10000)");
    }

    @Test
    public void testEarliestUnreleasedVersion() throws Exception {
        this.createSearchAndAssertIssues("fixVersion = earliestUnreleasedVersion(MKY)", "MKY-1");
        this.createSearchAndAssertIssues("affectedVersion = earliestUnreleasedVersion(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(MK)", "MK-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(HSP)", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(hsp)", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(homosapien)", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(HOMOSAPIEN)", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(10000)", "NUMBER-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(monkey)", "MKY-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(MK)", "MK-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(10001)", "MKY-2");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(HSP, MKY)", "MKY-2", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(HSP, MKY, MK)", "MKY-2", "MK-2", "HSP-3");
        this.createSearchAndAssertIssues("VP = earliestUnreleasedVersion(HSP, 10001)", "MKY-2", "HSP-3");
        this.navigation.issueNavigator().loadFilter(10030L);
        this.tester.assertTextPresent("VP = earliestUnreleasedVersion(HSP)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.issueTableAssertions.assertSearchWithErrorForUser("fred", "VP = earliestUnreleasedVersion(HSP)", "Could not resolve the project 'HSP' provided to function 'earliestUnreleasedVersion'.");
        this.navigation.issueNavigator().loadFilter(10030L);
        this.tester.assertTextPresent("VP = earliestUnreleasedVersion(10000)");
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }
}

