/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.fixversion;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.ChangeHistoryAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@LoginAs(user="admin")
@Restore(value="TestFixVersionWasSearching.xml")
public class TestFixVersionWasSearching
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "fixversion";
    private static final String VERSION_1 = "'New Version 1'";
    private static final String VERSION_2 = "'New Version 4'";
    private static final String VERSION_3 = "'New Version 5'";
    private static final String EMPTY_VERSION = "EMPTY";
    private static final String INDEXING_LIMIT = "6";
    private static final long HSP_PROJECT_ID = 10000L;
    @Inject
    private ChangeHistoryAssertions history;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.systemProperties().setProperty("jira.safeguards.indexing.issue.changelogs", INDEXING_LIMIT);
        this.backdoor.indexing().reindexProject(10000L);
    }

    @After
    public void tearDown() {
        this.backdoor.systemProperties().unsetProperty("jira.safeguards.indexing.issue.changelogs");
    }

    @Test
    public void testWasEmptySearch() {
        String[] issueKeys = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.history.assertWasEmptySearchReturnsEmptyValuesUsingEmptyKeyword(FIELD_NAME, issueKeys);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasNotEmptySearch() {
        String[] issueKeys = new String[]{"HSP-14", "HSP-13"};
        this.history.assertWasNotEmptySearchReturnsNotEmptyValuesWithEmptyKeyword(FIELD_NAME, issueKeys);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchUsingSingleValueOperandsReturnsExpectedValues() {
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1");
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-3");
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_3, "HSP-14", "HSP-12", "HSP-11", "HSP-3");
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchUsingListOperands() {
        HashSet versions = Sets.newHashSet((Object[])new String[]{VERSION_1, VERSION_2});
        this.history.assertWasInSearchReturnsExpectedValues(FIELD_NAME, versions, "HSP-14", "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-3", "HSP-1");
        versions = Sets.newHashSet((Object[])new String[]{VERSION_2, VERSION_3});
        this.history.assertWasInSearchReturnsExpectedValues(FIELD_NAME, versions, "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-3");
    }

    @Test
    public void testWasNotInSearchUsingListOperands() {
        HashSet versions = Sets.newHashSet((Object[])new String[]{VERSION_1, VERSION_3});
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-2"};
        this.history.assertWasNotInSearchReturnsExpectedValues(FIELD_NAME, versions, expected);
    }

    @Test
    public void testWasSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.history.assertWasBySearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "admin", expected);
        expected = new String[]{};
        this.history.assertWasBySearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "fred", expected);
        expected = new String[]{"HSP-9"};
        this.history.assertWasBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "empty", Sets.newHashSet((Object[])new String[]{"fred", "bob"}), expected);
    }

    @Test
    public void testWasSearchUsingDuringPredicate() {
        String[] expected = new String[]{"HSP-1"};
        this.history.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", "'2011/05/31'", expected);
    }

    @Test
    public void testWasSearchUsingBeforePredicate() {
        String[] expected = new String[]{};
        this.history.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        this.history.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/19 10:55'", expected);
    }

    @Test
    public void testWasSearchUsingAfterPredicate() {
        String[] expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.history.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-1"};
        this.history.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/08/26 14:29'", expected);
    }

    @Test
    public void testWasSearchUsingOnPredicate() {
        String[] expected = new String[]{};
        this.history.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        this.history.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/06/01'", expected);
    }

    @Test
    public void testWasSearchUsingLongOperandsIsValid() {
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, "10000", "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1");
    }

    @Test
    public void testWasSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        this.history.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob", "", expectedError);
    }

    @Test
    public void testWasSearchUsingIncorrectPredicateIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 28)";
        this.history.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob)", "at '10:55'", expectedError);
    }

    @Test
    public void testWasSearchingNotIndexedField() {
        String[] expectedIssues = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, expectedIssues);
        expectedIssues = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, EMPTY_VERSION, expectedIssues);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchingIndexedField() {
        String[] expectedIssues = new String[]{"HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-3"};
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, expectedIssues);
        expectedIssues = new String[]{"HSP-14", "HSP-12", "HSP-11", "HSP-3"};
        this.history.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_3, expectedIssues);
    }
}

