/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status.daterange;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.ChangeHistoryAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@Restore(value="TestSearchIssueStatusAfterADate.xml")
@LoginAs(user="admin")
public class TestSearchIssueStatusAfterADate
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "status";
    @Inject
    private ChangeHistoryAssertions changeHistoryAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testInvalidAfterInput() {
        String expectedError = "The AFTER predicate must be supplied with only 1 date value.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "AFTER ('2011-07-01','2011-07-01')", expectedError);
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "AFTER ('2011-07-01','2011-07-03','2012-07-03')", expectedError);
    }

    @Test
    public void testReturnsTheIssuesThatWereInTheStatusAndTransitionedToThatStatusAfterTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsContain("SHT-4", "SHT-5", "SHT-10");
    }

    @Test
    public void testReturnsTheIssuesThatWereInTheStatusAndTransitionedToThatStatusBeforeTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsContain("SHT-1", "SHT-2");
    }

    @Test
    public void testDoesNotReturnIssuesThatWereNeverInTheSpecifiedStatus() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-6", "SHT-7");
    }

    @Test
    public void testDoesNotReturnIssuesThatWereNotInTheStatusGivenThatTheIssuesWereInThatStatusAtADateOutsideTheRange() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-6", "SHT-7");
    }

    @Test
    public void testDoesNotReturnIssuesThatTransitionedToTheSpecifiedStatusAtTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-3");
    }
}

