/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.webtests.LicenseKeys;
import com.jayway.awaitility.Awaitility;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestArchiveProject
extends BaseJiraFuncTest {
    private static final String PROJECT_ACTIVE = "ACT";
    private static final String PROJECT_ARCHIVED = "ARCH";
    private static final String ARCHIVE_BUTTON_NAME = "archive";
    private static final String PROJECT_ARCHIVED_EVENT = "com.atlassian.jira.event.project.ProjectArchivedEvent";
    private static final String PROJECT_RESTORED_EVENT = "com.atlassian.jira.event.project.ProjectRestoredEvent";
    private Long projectActiveId;
    private Long projectArchivedId;
    @Inject
    private FuncTestRestClient restClient;

    private void restoreInstance() {
        this.backdoor.restoreBlankInstance();
        this.projectActiveId = this.backdoor.project().addProject("Active project", PROJECT_ACTIVE, "admin");
        this.projectArchivedId = this.backdoor.project().addProject("Archived project", PROJECT_ARCHIVED, "admin");
    }

    @AfterEach
    public void cleanup() {
        this.backdoor.events().stopAllPollers();
    }

    @Test
    public void testHappyPath() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        MatcherAssert.assertThat(this.getIssues(PROJECT_ACTIVE), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getIssues(PROJECT_ARCHIVED), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveWithoutBrowseProjects() {
        this.restoreInstance();
        this.navigation.browseProject(PROJECT_ARCHIVED);
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        this.navigation.browseProject(PROJECT_ARCHIVED);
        this.assertions.assertNodeHasText("//h1[@class='projects-error-page-heading']", "You can't view this project");
        Response response = this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NO_CONTENT));
    }

    @Test
    public void testArchiveProject() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        this.backdoor.analyticsEventsControl().enable();
        this.backdoor.analyticsEventsControl().clear();
        MatcherAssert.assertThat(this.backdoor.analyticsEventsControl().matchEvents("jira.project.archive"), (Matcher)Matchers.hasSize((int)0));
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.assertProjectArchived(PROJECT_ACTIVE, poller.events(), false);
        this.backdoor.project().archiveProject(PROJECT_ACTIVE);
        Awaitility.await().until(() -> this.backdoor.analyticsEventsControl().matchEvents("jira.project.archive"), Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        this.assertProjectArchived(PROJECT_ACTIVE, poller.events(), true);
        MatcherAssert.assertThat(this.getIssues(PROJECT_ARCHIVED), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        this.backdoor.analyticsEventsControl().disable();
    }

    @Test
    public void testReopenProject() {
        this.restoreInstance();
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.createIssuesAndArchiveProject(1);
        this.assertProjectRestored(PROJECT_ARCHIVED, poller.events(), false);
        this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        this.backdoor.indexing().reindexAll();
        MatcherAssert.assertThat(this.getIssues(PROJECT_ACTIVE), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        this.assertProjectRestored(PROJECT_ARCHIVED, poller.events(), true);
    }

    @Test
    public void testReindexReopenedProject() {
        this.restoreInstance();
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.createIssuesAndArchiveProject(1);
        this.assertProjectRestored(PROJECT_ARCHIVED, poller.events(), false);
        this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        this.backdoor.indexing().reindexProject(this.projectArchivedId);
        MatcherAssert.assertThat(this.getIssues(PROJECT_ACTIVE), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
        this.assertProjectRestored(PROJECT_ARCHIVED, poller.events(), true);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=960000)
    public void testReindexRestoredProject() throws JSONException {
        this.backdoor.restoreInstance("xml/TestArchiveProject.xml", LicenseKeys.COMMERCIAL_DC);
        this.projectActiveId = Long.valueOf(this.backdoor.project().getProject((String)PROJECT_ACTIVE).id);
        this.projectArchivedId = Long.valueOf(this.backdoor.project().getProject((String)PROJECT_ARCHIVED).id);
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)PROJECT_ACTIVE).archived, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)PROJECT_ARCHIVED).archived, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(this.getIssues(PROJECT_ACTIVE), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getIssues(PROJECT_ARCHIVED), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.backdoor.project().restoreProject(PROJECT_ACTIVE);
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)PROJECT_ACTIVE).archived, (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)PROJECT_ARCHIVED).archived, (Matcher)CoreMatchers.is((Object)true));
        this.backdoor.indexing().reindexProject(this.projectActiveId);
        this.backdoor.indexing().reindexProject(this.projectArchivedId);
        MatcherAssert.assertThat(this.getIssues(PROJECT_ACTIVE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(this.getIssues(PROJECT_ARCHIVED), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(poller.events(), (Matcher)IsCollectionContaining.hasItem((Object)PROJECT_RESTORED_EVENT));
    }

    @Test
    public void testDeleteArchivedProject() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        MatcherAssert.assertThat((Object)this.backdoor.project().getProjectId(PROJECT_ARCHIVED), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.backdoor.project().deleteProject(PROJECT_ARCHIVED);
        try {
            Assert.assertNull((Object)this.backdoor.project().getProjectId(PROJECT_ARCHIVED));
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteArchivedProjectNoPermission() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        MatcherAssert.assertThat((Object)this.backdoor.project().getProjectId(PROJECT_ARCHIVED), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        ((ProjectClient)new ProjectClient((JIRAEnvironmentData)this.environmentData).loginAs("fred", "fred")).delete(PROJECT_ARCHIVED);
        try {
            MatcherAssert.assertThat((Object)this.backdoor.project().getProjectId(PROJECT_ARCHIVED), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
    }

    @Test(expected=RuntimeException.class)
    public void testAddIssuesToArchivedProject() {
        this.restoreInstance();
        this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        this.backdoor.issues().createIssue(PROJECT_ARCHIVED, "second issue in archived project");
    }

    @Test
    public void testArchivedProjectDisappearsFromList() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        MatcherAssert.assertThat(this.getProjectKeys(), (Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ACTIVE));
        this.backdoor.project().archiveProject(PROJECT_ACTIVE);
        MatcherAssert.assertThat(this.getProjectKeys(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ACTIVE)));
    }

    @Test
    public void testArchivedProjectAppearsOnListList() {
        this.restoreInstance();
        this.createIssuesAndArchiveProject(1);
        MatcherAssert.assertThat(this.getProjectKeys(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED)));
        this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat(this.getProjectKeys(), (Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED));
    }

    private List<String> getProjectKeys() {
        return this.backdoor.project().getProjects().stream().map(project -> project.key).collect(Collectors.toList());
    }

    private void createIssuesAndArchiveProject(int archivedIssuesCount) {
        this.backdoor.issues().createIssue(PROJECT_ACTIVE, "issue in open project");
        IntStream.range(0, archivedIssuesCount).parallel().forEach(i -> this.backdoor.issues().createIssue(PROJECT_ARCHIVED, "issue in archived project"));
        this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
    }

    private List<Issue> getIssues(String projectKey) {
        return this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)new StringBuilder().append((String)"project=").append((String)projectKey).toString())).issues;
    }

    @Test
    public void testArchiveResourceUserNotLoggedIn() {
        this.restoreInstance();
        this.backdoor.project().anonymous();
        Response response = this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.UNAUTHORIZED));
        this.backdoor.project().loginAs("admin", "admin");
    }

    @Test
    public void testRestoreResourceUserNotLoggedIn() {
        this.restoreInstance();
        this.backdoor.project().anonymous();
        Response response = this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.UNAUTHORIZED));
        this.backdoor.project().loginAs("admin", "admin");
    }

    @Test
    public void testArchiveResourceUserHasNoPermission() {
        this.restoreInstance();
        this.backdoor.project().loginAs("fred", "fred");
        Response response = this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.backdoor.project().loginAs("admin", "admin");
    }

    @Test
    public void testRestoreResourceUserHasNoPermission() {
        this.restoreInstance();
        this.backdoor.project().loginAs("fred", "fred");
        Response response = this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.backdoor.project().loginAs("admin", "admin");
    }

    @Test
    public void testArchiveResourceProjectDoesntExist() {
        this.restoreInstance();
        Response response = this.backdoor.project().archiveProject("SOMETHING");
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND));
    }

    @Test
    public void testRestoreResourceProjectDoesntExist() {
        this.restoreInstance();
        Response response = this.backdoor.project().restoreProject("SOMETHING");
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND));
    }

    @Test
    public void testArchiveResourceArchiveAlreadyArchived() {
        this.restoreInstance();
        Response firstResponse = this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        Response secondResponse = this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)firstResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NO_CONTENT));
        MatcherAssert.assertThat((Object)secondResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
    }

    @Test
    public void testRestoreResourceArchiveAlreadyRestored() {
        this.restoreInstance();
        this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
        Response firstResponse = this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        Response secondResponse = this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        MatcherAssert.assertThat((Object)firstResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.ACCEPTED));
        MatcherAssert.assertThat((Object)secondResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST));
    }

    private void testCountOfArchivedIssuesBeforeAndAfterOperation(Runnable runnable) {
        Long archivedProjectIssueCount = 5L;
        this.createIssuesAndArchiveProject(Math.toIntExact(archivedProjectIssueCount));
        Long countInArchiveBeforeOperation = this.backdoor.indexSummaryClient().getIndexSummary().getIssueIndex().getCountInArchive();
        runnable.run();
        Long countInArchiveAfterOperation = this.backdoor.indexSummaryClient().getIndexSummary().getIssueIndex().getCountInArchive();
        MatcherAssert.assertThat((String)"Issue count before operation should be equal to project count", (Object)countInArchiveBeforeOperation, (Matcher)CoreMatchers.is((Object)archivedProjectIssueCount));
        MatcherAssert.assertThat((String)"Issue count in archived project after operation should be 0", (Object)countInArchiveAfterOperation, (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=960000)
    public void testIfArchivedIssueCountIsChangedAfterProjectDeletion() {
        this.restoreInstance();
        this.testCountOfArchivedIssuesBeforeAndAfterOperation(() -> this.backdoor.project().deleteProject(PROJECT_ARCHIVED));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=960000)
    public void testIfArchivedIssueCountIsChangedAfterProjectRestoration() {
        this.restoreInstance();
        this.testCountOfArchivedIssuesBeforeAndAfterOperation(() -> this.backdoor.project().restoreProject(PROJECT_ARCHIVED));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=960000)
    public void testIfArchivedIssueCountIsChangedAfterInstanceRestore() {
        this.restoreInstance();
        this.testCountOfArchivedIssuesBeforeAndAfterOperation(this::restoreInstance);
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveProjectRedirectsToAdminProjects() {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.restoreInstance();
        MatcherAssert.assertThat(poller.events(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED_EVENT)));
        this.tester.gotoPage("secure/project/ArchiveProject!default.jspa?pid=10000");
        this.tester.assertTextPresent("After you archive this project");
        this.tester.assertElementPresent("confirm-project-archive-button");
        this.tester.submit(ARCHIVE_BUTTON_NAME);
        this.tester.assertElementPresent("browse-projects-page");
        MatcherAssert.assertThat(poller.events(), (Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED_EVENT));
    }

    @Test
    public void testArchivedProjectsLinkForPLA() {
        this.restoreInstance();
        this.navigation.login("fred");
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, "fred");
        this.tester.gotoPage("secure/project/BrowseProjects.jspa?s=view_projects");
        this.tester.assertElementNotPresent("view_archived_projects");
    }

    private void assertProjectArchived(String projectKey, Iterable<String> events, boolean archived) {
        MatcherAssert.assertThat(events, (Matcher)(archived ? IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED_EVENT) : CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)PROJECT_ARCHIVED_EVENT))));
        MatcherAssert.assertThat(this.getIssues(projectKey), (Matcher)(archived ? CoreMatchers.is((Matcher)Matchers.empty()) : CoreMatchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)projectKey).archived, (Matcher)CoreMatchers.is((Object)archived));
    }

    private void assertProjectRestored(String projectKey, Iterable<String> events, boolean restored) {
        MatcherAssert.assertThat(events, (Matcher)(restored ? IsCollectionContaining.hasItem((Object)PROJECT_RESTORED_EVENT) : CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)PROJECT_RESTORED_EVENT))));
        MatcherAssert.assertThat(this.getIssues(projectKey), (Matcher)(restored ? CoreMatchers.not((Matcher)Matchers.empty()) : CoreMatchers.is((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)this.backdoor.project().getProject((String)projectKey).archived, (Matcher)CoreMatchers.not((Object)restored));
    }
}

