/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.AdvancedAuditingClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.jayway.awaitility.Awaitility;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestArchiveProjectAuditing
extends BaseJiraFuncTest {
    private static final String PROJECT_ACTIVE = "ACT";
    private static final String PROJECT_ARCHIVED = "ARCH";
    private Long projectActiveId;
    private Long projectArchivedId;

    private void restoreInstance() {
        this.backdoor.restoreBlankInstance();
        this.projectActiveId = this.backdoor.project().addProject("Active project", PROJECT_ACTIVE, "admin");
        this.projectArchivedId = this.backdoor.project().addProject("Archived project", PROJECT_ARCHIVED, "admin");
    }

    private void restoreAndWaitForAuditPlugin(Runnable restore) {
        this.backdoor.server().setLogLevel("com.atlassian.activeobjects.osgi.TenantAwareActiveObjects", Level.DEBUG);
        this.backdoor.server().recordLogs(true);
        try {
            restore.run();
            Awaitility.await((String)"atlassian-audit-plugin creates ActiveObjects.").atMost(1L, TimeUnit.MINUTES).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> this.backdoor.server().getLogs().contains("bundle [com.atlassian.audit.atlassian-audit-plugin] created ActiveObjects"));
            this.backdoor.advancedAuditing().allAreasTo("base");
        }
        finally {
            this.backdoor.server().recordLogs(false);
        }
    }

    @Test
    public void testArchiveProjectAuditing() {
        this.restoreAndWaitForAuditPlugin(this::restoreInstance);
        this.createIssuesAndArchiveProject(1);
        this.verifyNoAudit("Project archived", this.projectActiveId);
        this.backdoor.project().archiveProject(PROJECT_ACTIVE);
        this.verifyAudit("Project archived", this.projectActiveId);
    }

    @Test
    public void testRestoreProjectAuditing() {
        this.restoreAndWaitForAuditPlugin(this::restoreInstance);
        this.createIssuesAndArchiveProject(1);
        this.verifyNoAudit("Project restored", this.projectArchivedId);
        this.backdoor.project().restoreProject(PROJECT_ARCHIVED);
        this.verifyAudit("Project restored", this.projectArchivedId);
    }

    private void createIssuesAndArchiveProject(int archivedIssuesCount) {
        this.backdoor.issues().createIssue(PROJECT_ACTIVE, "issue in open project");
        IntStream.range(0, archivedIssuesCount).parallel().forEach(i -> this.backdoor.issues().createIssue(PROJECT_ARCHIVED, "issue in archived project"));
        this.backdoor.project().archiveProject(PROJECT_ARCHIVED);
    }

    private void verifyAudit(String summary, long projectId) {
        AdvancedAuditingClient.AuditAffectedObjects affectedObject = this.backdoor.advancedAuditing().waitUntilEventIsFound(summary).getAffectedObjects().get(0);
        MatcherAssert.assertThat((Object)affectedObject.getId(), (Matcher)CoreMatchers.is((Object)String.valueOf(projectId)));
    }

    private void verifyNoAudit(String summary, long projectId) {
        MatcherAssert.assertThat(this.getAuditMessages(projectId), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)summary)));
    }

    private List<String> getAuditMessages(long projectId) {
        List<AdvancedAuditingClient.AuditEntities> auditEntities = this.backdoor.advancedAuditing().takeAllEventsWithAffectedObject("PROJECT", String.valueOf(projectId));
        return auditEntities.stream().map(entity -> entity.getType().getAction()).collect(Collectors.toList());
    }
}

