/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@LoginAs(user="admin")
public class TestEditProjectLeadAndDefaultAssignee
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestEditProject.xml");
    }

    @Test
    public void testProjectDoesNotExistAdmin() throws Exception {
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    @Test
    public void testProjectDoesNotExistNonAdmin() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("You must log in to access this page.");
        this.navigation.login("gandhi");
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertTextNotPresent("You cannot view this URL as a guest.");
    }

    @Test
    public void testEditProjectSuccess() {
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)dog.key);
        Assert.assertEquals((Object)"Canine", (Object)dog.name);
        Assert.assertEquals((Object)"", (Object)dog.description);
        Assert.assertEquals(null, (Object)dog.url);
        Assert.assertEquals((Object)"murray", (Object)dog.lead.name);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"admin"});
        formParameterUtil.setFormElement("lead", "admin");
        formParameterUtil.submitForm();
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        this.tester.setFormElement("lead", "admin");
        this.tester.selectOption("assigneeType", "Unassigned");
        this.tester.submit("Update");
        dog = pc.get("DOG");
        Assert.assertThat((Object)dog.name, (Matcher)CoreMatchers.equalTo((Object)"Canine"));
        Project newDog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)newDog.key);
        Assert.assertEquals((Object)"Canine", (Object)newDog.name);
        Assert.assertEquals((Object)"", (Object)newDog.description);
        Assert.assertEquals(null, (Object)newDog.url);
        Assert.assertEquals((Object)"admin", (Object)newDog.lead.name);
        Assert.assertEquals((Object)Project.AssigneeType.UNASSIGNED, (Object)newDog.assigneeType);
    }

    @Test
    public void testEditProjectChangeNothing() {
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        this.tester.assertTextPresent("Edit Project Lead and Default Assignee for Project: Canine");
        this.tester.setFormElement("lead", "murray");
        this.tester.selectOption("assigneeType", "Project Lead");
        this.tester.submit("Update");
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        Assert.assertEquals((Object)"DOG", (Object)dog.key);
        Assert.assertEquals((Object)"Canine", (Object)dog.name);
        Assert.assertEquals((Object)"", (Object)dog.description);
        Assert.assertEquals(null, (Object)dog.url);
        Assert.assertEquals((Object)"murray", (Object)dog.lead.name);
        Assert.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
    }
}

