/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.testkit.beans.ProjectSchemesBean;
import com.atlassian.jira.testkit.client.restclient.Project;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Restore(value="TestProjectCreateBasedOnExisting.xml")
@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestProjectCreateBasedOnExisting
extends BaseJiraFuncTest {
    private static final String EXISTING_PROJECT_KEY = "CUS";

    @Before
    public void setUp() throws Exception {
        Project existingProject = this.backdoor.project().getProject(EXISTING_PROJECT_KEY);
        this.backdoor.project().updateProjectType(Long.valueOf(existingProject.id), new ProjectTypeKey("business"));
    }

    @Test
    public void testSchemesAreSharedForNewProject() {
        String newProjectKey = this.backdoor.project().addProjectBasedOnExisting(EXISTING_PROJECT_KEY, "SHRD", "Shared Project", "admin");
        Project project = this.backdoor.project().getProject(newProjectKey);
        ProjectSchemesBean schemes = this.backdoor.project().getSchemes(newProjectKey);
        Assert.assertThat((Object)project.id, (Matcher)Matchers.is((Object)"10110"));
        Assert.assertThat((Object)schemes.permissionScheme.id, (Matcher)Matchers.is((Object)10000L));
        Assert.assertThat((Object)schemes.notificationScheme.id, (Matcher)Matchers.is((Object)10010L));
        Assert.assertThat((Object)schemes.workflowScheme.getId(), (Matcher)Matchers.is((Object)10100L));
        Assert.assertThat((Object)schemes.issueSecurityScheme.id, (Matcher)Matchers.is((Object)10000L));
        Assert.assertThat((Object)schemes.issueTypeScheme.id, (Matcher)Matchers.is((Object)10010L));
        Assert.assertThat((Object)schemes.fieldConfigurationScheme.id, (Matcher)Matchers.is((Object)10000L));
    }
}

