/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeBean;
import com.atlassian.jira.rest.v2.issue.IssueTypeSchemeListBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.CreateSharedProjectResourceClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueTypeSchemeClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestProjectCreateFromSharedConfigurationConcurrently
extends BaseJiraFuncTest {
    private static final String XML_BACKUP = "TestProjectCreateFromSharedConfigurationConcurrently-1Projects.xml";
    private static final String PRIORITY_SCHEME_NAME = "Non-default Priority Scheme";
    private static final String ISSUETYPE_SCHEME_NAME = "Non-default Issue Type Scheme";

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    public void shouldNotRevertToDefaultPriorityScheme() throws InterruptedException {
        int numberOfProjectsToCreate = 300;
        int numberOfThreads = 60;
        int repeatTimes = 6;
        for (int i = 0; i < 6; ++i) {
            this.backdoor.restoreDataFromResource(XML_BACKUP);
            long prioritySchemeId = this.backdoor.prioritySchemes().getSchemeByName(PRIORITY_SCHEME_NAME).getId();
            List<Long> originalProjectsWithNonDefaultPriorityScheme = this.backdoor.prioritySchemes().getProjectWithScheme(prioritySchemeId);
            this.createConcurrentlyWithSharedConfiguration(300, 60);
            List<Long> currentProjectsWithNonDefaultPriorityScheme = this.backdoor.prioritySchemes().getProjectWithScheme(prioritySchemeId);
            Assert.assertTrue((boolean)currentProjectsWithNonDefaultPriorityScheme.containsAll(originalProjectsWithNonDefaultPriorityScheme));
            ArrayList<Long> projectsFromOriginalList = new ArrayList<Long>(currentProjectsWithNonDefaultPriorityScheme);
            projectsFromOriginalList.retainAll(originalProjectsWithNonDefaultPriorityScheme);
            Assert.assertEquals((long)new HashSet<Long>(projectsFromOriginalList).size(), (long)projectsFromOriginalList.size());
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    @Restore(value="TestProjectCreateFromSharedConfigurationConcurrently-1Projects.xml")
    public void allNewProjectsShouldBeAssociatedWithNonDefaultPriorityScheme() throws InterruptedException {
        int numberOfProjectsToCreate = 20;
        int numberOfThreads = 10;
        long prioritySchemeId = this.backdoor.prioritySchemes().getSchemeByName(PRIORITY_SCHEME_NAME).getId();
        List<Long> addedProjectIds = this.createConcurrentlyWithSharedConfiguration(20, 10);
        List<Long> currentProjectsWithNonDefaultPriorityScheme = this.backdoor.prioritySchemes().getProjectWithScheme(prioritySchemeId);
        Assert.assertTrue((boolean)currentProjectsWithNonDefaultPriorityScheme.containsAll(addedProjectIds));
        Assert.assertEquals((long)new HashSet<Long>(currentProjectsWithNonDefaultPriorityScheme).size(), (long)currentProjectsWithNonDefaultPriorityScheme.size());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    public void shouldNotRevertExistingProjectsToDefaultIssueTypeScheme() throws InterruptedException {
        int numberOfProjectsToCreate = 300;
        int numberOfThreads = 50;
        this.backdoor.restoreDataFromResource(XML_BACKUP);
        long issueTypeSchemeId = this.getIssueTypeSchemeId();
        List<Long> originalProjectsWithNonDefaultIssueTypeScheme = this.getProjectsAssociatedWithIssueTypeScheme(issueTypeSchemeId);
        this.createConcurrentlyWithSharedConfiguration(300, 50);
        List<Long> currentProjectsWithNonDefaultIssueTypeScheme = this.getProjectsAssociatedWithIssueTypeScheme(issueTypeSchemeId);
        Assert.assertTrue((boolean)currentProjectsWithNonDefaultIssueTypeScheme.containsAll(originalProjectsWithNonDefaultIssueTypeScheme));
        ArrayList<Long> projectsFromOriginalList = new ArrayList<Long>(currentProjectsWithNonDefaultIssueTypeScheme);
        projectsFromOriginalList.retainAll(originalProjectsWithNonDefaultIssueTypeScheme);
        Assert.assertEquals((long)new HashSet<Long>(projectsFromOriginalList).size(), (long)projectsFromOriginalList.size());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=814000)
    @Restore(value="TestProjectCreateFromSharedConfigurationConcurrently-1Projects.xml")
    public void newProjectsShouldBeAssociatedWithNonDefaultIssueTypeScheme() throws InterruptedException {
        int numberOfProjectsToCreate = 20;
        int numberOfThreads = 10;
        List<Long> addedProjectIds = this.createConcurrentlyWithSharedConfiguration(20, 10);
        long issueTypeSchemeId = this.getIssueTypeSchemeId();
        List<Long> currentProjectsWithNonDefaultIssueTypeScheme = this.getProjectsAssociatedWithIssueTypeScheme(issueTypeSchemeId);
        Assert.assertTrue((boolean)currentProjectsWithNonDefaultIssueTypeScheme.containsAll(addedProjectIds));
        Assert.assertEquals((long)new HashSet<Long>(currentProjectsWithNonDefaultIssueTypeScheme).size(), (long)currentProjectsWithNonDefaultIssueTypeScheme.size());
    }

    private Long getIssueTypeSchemeId() {
        IssueTypeSchemeClient itsClient = new IssueTypeSchemeClient(this.environmentData);
        return ((IssueTypeSchemeListBean)itsClient.getAllIssueTypeSchemes().body).getSchemes().stream().filter(its -> ISSUETYPE_SCHEME_NAME.equals(its.getName())).map(IssueTypeSchemeBean::getId).map(Long::parseLong).findFirst().orElse(null);
    }

    private List<Long> getProjectsAssociatedWithIssueTypeScheme(long issueTypeSchemeId) {
        IssueTypeSchemeClient itsClient = new IssueTypeSchemeClient(this.environmentData);
        return ((List)itsClient.getProjectsAssociatedWithIssueTypeScheme((long)issueTypeSchemeId).body).stream().map(ps -> ps.id).map(Long::parseLong).collect(Collectors.toList());
    }

    private List<Long> createConcurrentlyWithSharedConfiguration(int numberOfProjectsToCreate, int numberOfThreads) throws InterruptedException {
        long testTimeoutMins = 5L;
        String fromProjectKey = "PF";
        CreateSharedProjectResourceClient client = new CreateSharedProjectResourceClient(this.environmentData);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        long fromProjectId = this.backdoor.project().getProjectId("PF");
        Collection tasks = IntStream.rangeClosed(1, numberOfProjectsToCreate).mapToObj(i -> () -> client.createSharedProject(fromProjectId, "PKEY" + i, "ProjectName" + i, "admin")).collect(Collectors.toList());
        List futures = executor.invokeAll(tasks, 5L, TimeUnit.MINUTES);
        executor.shutdown();
        ArrayList<Long> addedProjectIds = new ArrayList<Long>();
        try {
            for (Future future : futures) {
                addedProjectIds.add((Long)future.get());
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return addedProjectIds;
    }
}

