/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.client.WebTarget;

public class ProjectShortcutsClient
extends RestApiClient<ProjectShortcutsClient> {
    private ProjectShortcutsClient(JIRAEnvironmentData environmentData, String loginAs) {
        super(environmentData);
        this.loginAs = loginAs;
    }

    static ProjectShortcutsClient getAuthenticatedShortcutsClient(JIRAEnvironmentData environmentData) {
        return new ProjectShortcutsClient(environmentData, "admin");
    }

    static ProjectShortcutsClient getUnauthenticatedShortcutsClient(JIRAEnvironmentData environmentData) {
        return new ProjectShortcutsClient(environmentData, null);
    }

    ProjectShortcut getShortcutsForProjectKey(@Nonnull String projectKey) {
        return (ProjectShortcut)this.localShortcutsEndpoint().path(projectKey).request().get(ProjectShortcut.class);
    }

    private WebTarget localShortcutsEndpoint() {
        return this.createResource().path("local");
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("project-shortcuts").path("latest");
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ProjectShortcut {
        public List<Shortcut> shortcuts;

        ProjectShortcut() {
        }

        public List<Shortcut> getShortcuts() {
            return this.shortcuts;
        }

        public void setShortcuts(List<Shortcut> shortcuts) {
            this.shortcuts = shortcuts;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class Shortcut {
            Shortcut() {
            }
        }
    }
}

