/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.webtests.ztests.project.security.TestOptimisedUserSearch;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.PERMISSIONS, Category.ISSUES, Category.USER_LOOKUP, Category.TPM})
@RestoreOnce(value="TestWithLDAP.zip")
public class TestOptimisedUserSearchInAssignees
extends TestOptimisedUserSearch {
    @Override
    protected boolean issueAlreadyExists() {
        return true;
    }

    @Override
    protected ProjectPermissionKey getPermission() {
        return ProjectPermissions.ASSIGNABLE_USER;
    }

    @Override
    protected TestOptimisedUserSearch.UserSearchResults getUserSearchResults() {
        return this.getUserSearchResults("");
    }

    @Override
    protected TestOptimisedUserSearch.UserSearchResults getUserSearchResults(String query) {
        return this.getAssignees(this.issueKey, query);
    }

    private TestOptimisedUserSearch.UserSearchResults getAssignees(String issueKey, String query) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<String> assignable = this.backdoor.userClient().getAssignees(query, "HSP", issueKey, this.maxResults).stream().map(assignableCandidate -> assignableCandidate.name).collect(Collectors.toList());
        return new TestOptimisedUserSearch.UserSearchResults(stopwatch.elapsed(TimeUnit.MILLISECONDS), assignable);
    }

    @Override
    protected void multiplePermissionsCorrectOrderingAssertion(String admin, String userAndrzej, String userAnkit, String userAntoni, String userDaria, String userJakub, String userKamil, String userKarol, String userMaciej, String userSzymonG, String userSzymonK) {
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{admin, userAndrzej, userAnkit, userAntoni, userDaria, userJakub, userKamil, userKarol, userMaciej, userSzymonG, userSzymonK}));
    }

    @Override
    protected void searchPerformanceAfterReporterIsAnonymizedAssertion() {
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
        String anonymisedUserKey = this.backdoor.usersAndGroups().getUserByName(USER_ALBERT).getKey();
        this.userAnonymizeControl.anonymize(anonymisedUserKey);
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Override
    protected void searchPerformanceWhenReporterIsNotSetAssertion() {
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
        this.setReporter(this.issueKey, "");
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALBERT, USER_ALICE}));
    }

    @Override
    protected void searchPerformanceWhenIssueIsUnassignedAssertion() {
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE, USER_BOB}));
        this.backdoor.generalConfiguration().allowUnassignedIssues();
        this.backdoor.project().setProjectDefaultAssignee(10000L, false);
        this.backdoor.issues().assignIssue(this.issueKey, "-1");
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE, USER_BOB}));
    }

    @Override
    protected void searchPerformanceAfterAssigneeIsAnonymizedAssertion() {
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE, USER_ANNA}));
        String anonymizedUserKey = this.backdoor.usersAndGroups().getUserByName(USER_ANNA).getKey();
        this.userAnonymizeControl.anonymize(anonymizedUserKey);
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.FUNCTIONAL, Matchers.contains((Object[])new String[]{"admin", USER_ALICE}));
    }

    @Override
    protected void searchPerformanceWithManyResultsAssertion(List<String> firstNJiraUsers, int expectedMentionsCount) {
        List expectedResults = firstNJiraUsers.stream().sorted(String.CASE_INSENSITIVE_ORDER).limit(expectedMentionsCount).collect(Collectors.toList());
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.LOAD, Matchers.is((Matcher)Matchers.equalTo(expectedResults)));
    }
}

