/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.project.security.TestOptimisedUserSearch;
import com.atlassian.jira.webtests.ztests.project.security.TestOptimisedUserSearchInMentions;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.PERMISSIONS, Category.ISSUES, Category.USER_LOOKUP, Category.TPM})
@RestoreOnce(value="TestWithLDAP.zip")
public class TestOptimisedUserSearchInMentionsInNewIssue
extends TestOptimisedUserSearchInMentions {
    @Override
    protected boolean issueAlreadyExists() {
        return false;
    }

    @Override
    protected TestOptimisedUserSearch.UserSearchResults getUserSearchResults() {
        return this.getUserSearchResults("");
    }

    @Override
    protected TestOptimisedUserSearch.UserSearchResults getUserSearchResults(String query) {
        return this.getMentions("HSP", query);
    }

    private TestOptimisedUserSearch.UserSearchResults getMentions(String projectKey, String query) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<String> mentions = this.backdoor.userClient().getMentions(projectKey, this.maxResults, query).stream().map(mentionCandidate -> mentionCandidate.name).collect(Collectors.toList());
        return new TestOptimisedUserSearch.UserSearchResults(stopwatch.elapsed(TimeUnit.MILLISECONDS), mentions);
    }

    @Override
    protected void searchPerformanceWithManyResultsAssertion(List<String> firstNJiraUsers, int expectedMentionsCount) {
        List expectedResults = firstNJiraUsers.stream().sorted(String.CASE_INSENSITIVE_ORDER).limit(expectedMentionsCount).collect(Collectors.toList());
        this.testSearchPerformance(TestOptimisedUserSearch.TestType.LOAD, Matchers.is((Matcher)Matchers.equalTo(expectedResults)));
    }
}

