/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.PermissionSchemesControl;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.PERMISSIONS, Category.ISSUES})
public class TestProjectPermissions
extends BaseJiraFuncTest {
    private static final String ISSUE_1_TITLE = "allowed 1";
    private static final String ISSUE_2_TITLE = "forbidden 2";
    private static final String FREDS_GROUP = "freds";
    private static final String BOBS_GROUP = "bobs";
    private PermissionSchemesControl permissionSchemesControl;
    private String issue1;
    private String issue2;
    private String[] issuesVisiblePerIssuePermission;
    private String[] issuesVisiblePerProjectPermission;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.backdoor.usersAndGroups().addGroup(FREDS_GROUP);
        this.backdoor.usersAndGroups().addUserToGroup("fred", FREDS_GROUP);
        this.backdoor.usersAndGroups().addGroup(BOBS_GROUP);
        this.backdoor.usersAndGroups().addUserToGroup("bob", BOBS_GROUP);
        this.issue1 = this.backdoor.issues().createIssue((String)"HSP", (String)ISSUE_1_TITLE).key;
        this.issue2 = this.backdoor.issues().createIssue((String)"HSP", (String)ISSUE_2_TITLE).key;
        this.issuesVisiblePerIssuePermission = new String[]{this.issue1};
        this.issuesVisiblePerProjectPermission = new String[]{this.issue1, this.issue2};
        this.permissionSchemesControl = this.backdoor.permissionSchemes();
        this.permissionSchemesControl.addUserPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "admin");
        this.permissionSchemesControl.removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        for (String username : new String[]{"fred", "admin", "bob"}) {
            this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", username);
        }
    }

    @Test
    public void testAssigneePermission() {
        Supplier<Void> initialSetup = () -> {
            this.permissionSchemesControl.addUserPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "fred");
            this.permissionSchemesControl.addUserPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "bob");
            this.backdoor.issues().assignIssue(this.issue1, "fred");
            return null;
        };
        Consumer<Void> addPermissionToFred = noContext -> this.permissionSchemesControl.addCurrentAssigneePermission(0L, ProjectPermissions.BROWSE_PROJECTS);
        Consumer<Void> changePermissionToBob = noContext -> this.backdoor.issues().assignIssue(this.issue1, "bob");
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerIssuePermission);
    }

    @Test
    public void testReporterPermission() {
        Supplier<Void> initialSetup = () -> {
            this.setIssueReporter(this.issue1, "fred");
            return null;
        };
        Consumer<Void> addPermissionToFred = noContext -> this.permissionSchemesControl.addReporterPermission(0L, ProjectPermissions.BROWSE_PROJECTS);
        Consumer<Void> changePermissionToBob = noContext -> this.setIssueReporter(this.issue1, "bob");
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerIssuePermission);
    }

    @Test
    public void testProjectLeadPermission() {
        long projectHomosapId = this.backdoor.project().getProjectId("HSP");
        Supplier<Void> initialSetup = () -> {
            this.backdoor.project().setProjectLead(projectHomosapId, "fred");
            return null;
        };
        Consumer<Void> addPermissionToFred = noContext -> this.permissionSchemesControl.addProjectLeadPermission(0L, ProjectPermissions.BROWSE_PROJECTS);
        Consumer<Void> changePermissionToBob = noContext -> this.backdoor.project().setProjectLead(projectHomosapId, "bob");
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerProjectPermission);
    }

    @Test
    public void testProjectRolePermission() {
        Supplier<Long> initialSetup = () -> {
            this.backdoor.projectRole().addActors("HSP", "Developers", null, new String[]{"fred"});
            return this.backdoor.projectRole().get((String)"HSP", (String)"Developers").id;
        };
        Consumer<Long> addPermissionToFred = projectRoleId -> this.permissionSchemesControl.addProjectRolePermission(0L, ProjectPermissions.BROWSE_PROJECTS, projectRoleId.longValue());
        Consumer<Long> changePermissionToBob = projectRoleId -> this.backdoor.projectRole().addActors("HSP", "Developers", new String[]{BOBS_GROUP}, null);
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerProjectPermission);
    }

    @Test
    public void testApplicationAccessPermission() {
        Supplier<Void> initialSetup = () -> {
            this.backdoor.license().set(LicenseKeys.COMMERCIAL_CORE_ACTIVE_DC);
            this.backdoor.applicationRoles().putRole("jira-software", FREDS_GROUP);
            return null;
        };
        Consumer<Void> addPermissionToFred = noContext -> this.permissionSchemesControl.addApplicationRolePermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-software");
        Consumer<Void> changePermissionToBob = noContext -> this.backdoor.applicationRoles().putRole("jira-software", BOBS_GROUP);
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerProjectPermission);
    }

    @Test
    public void testUserPermission() {
        Supplier<Void> initialSetup = () -> null;
        Consumer<Void> addPermissionToFred = noContext -> this.permissionSchemesControl.addUserPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "fred");
        Consumer<Void> changePermissionToBob = noContext -> this.permissionSchemesControl.addUserPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "bob");
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerProjectPermission);
    }

    @Test
    public void testGroupPermission() {
        String TEST_GROUP = "test-group";
        Supplier<Void> initialSetup = () -> {
            this.backdoor.usersAndGroups().addGroup("test-group");
            this.backdoor.usersAndGroups().addUserToGroup("fred", "test-group");
            return null;
        };
        Consumer<Void> addPermissionToGroup = noContext -> this.permissionSchemesControl.addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "test-group");
        Consumer<Void> addBobToGroup = noContext -> this.backdoor.usersAndGroups().addUserToGroup("bob", "test-group");
        this.runTest(initialSetup, addPermissionToGroup, addBobToGroup, this.issuesVisiblePerProjectPermission);
    }

    @Test
    public void testGroupPickerSingleCustomFieldPermission() {
        this.testCustomFieldPermission("grouppicker", "grouppickersearcher", this.addNoCustomFieldOptions(), this.addGroupCustomFieldPermission(), ResourceRef.withName((String)FREDS_GROUP), ResourceRef.withName((String)BOBS_GROUP));
    }

    @Test
    public void testGroupPickerMultiCustomFieldPermission() {
        this.testCustomFieldPermission("multigrouppicker", "grouppickersearcher", this.addNoCustomFieldOptions(), this.addGroupCustomFieldPermission(), new ResourceRef[]{ResourceRef.withName((String)FREDS_GROUP)}, new ResourceRef[]{ResourceRef.withName((String)BOBS_GROUP)});
    }

    @Test
    public void testSingleSelectCustomFieldPermission() {
        this.testCustomFieldPermission("select", "multiselectsearcher", this.addCustomFieldOptions(), this.addGroupCustomFieldPermission(), ResourceRef.withValue((String)FREDS_GROUP), ResourceRef.withValue((String)BOBS_GROUP));
    }

    @Test
    public void testMultiSelectCustomFieldPermission() {
        this.testCustomFieldPermission("multiselect", "multiselectsearcher", this.addCustomFieldOptions(), this.addGroupCustomFieldPermission(), new ResourceRef[]{ResourceRef.withValue((String)FREDS_GROUP)}, new ResourceRef[]{ResourceRef.withValue((String)BOBS_GROUP)});
    }

    @Test
    public void testUserPickerSingleCustomFieldPermission() {
        this.testCustomFieldPermission("userpicker", "userpickergroupsearcher", this.addNoCustomFieldOptions(), this.addUserCustomFieldPermission(), ResourceRef.withName((String)"fred"), ResourceRef.withName((String)"bob"));
    }

    @Test
    public void testUserPickerMultiCustomFieldPermission() {
        this.testCustomFieldPermission("multiuserpicker", "userpickergroupsearcher", this.addNoCustomFieldOptions(), this.addUserCustomFieldPermission(), new ResourceRef[]{ResourceRef.withName((String)"fred")}, new ResourceRef[]{ResourceRef.withName((String)"bob")});
    }

    private void testCustomFieldPermission(String customFieldType, String customFieldSearcher, Consumer<String> addCustomFieldOptions, Consumer<String> addCustomFieldPermission, Object fredCustomFieldValue, Object bobCustomFieldValue) {
        Supplier<String> initialSetup = () -> {
            String customFieldId = this.addCustomField(customFieldType, customFieldSearcher);
            this.backdoor.screens().addFieldToScreen("Default Screen", "allow");
            addCustomFieldOptions.accept(customFieldId);
            this.setCustomField(this.issue1, customFieldId, fredCustomFieldValue);
            return customFieldId;
        };
        Consumer<String> addPermissionToFred = customFieldId -> addCustomFieldPermission.accept((String)customFieldId);
        Consumer<String> changePermissionToBob = customFieldId -> this.setCustomField(this.issue1, (String)customFieldId, bobCustomFieldValue);
        this.runTest(initialSetup, addPermissionToFred, changePermissionToBob, this.issuesVisiblePerIssuePermission);
    }

    private Consumer<String> addNoCustomFieldOptions() {
        return customFieldId -> {};
    }

    private Consumer<String> addCustomFieldOptions() {
        return customFieldId -> {
            this.backdoor.customFields().addOption(customFieldId, FREDS_GROUP);
            this.backdoor.customFields().addOption(customFieldId, BOBS_GROUP);
        };
    }

    private Consumer<String> addUserCustomFieldPermission() {
        return customFieldId -> this.permissionSchemesControl.addUserCustomFieldPermission(0L, ProjectPermissions.BROWSE_PROJECTS, customFieldId);
    }

    private Consumer<String> addGroupCustomFieldPermission() {
        return customFieldId -> this.permissionSchemesControl.addGroupCustomFieldPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, customFieldId);
    }

    private String addCustomField(String customFieldType, String customFieldSearcher) {
        return this.backdoor.customFields().createCustomField("allow", "Allow members of this custom field to see issues", CustomFields.builtInCustomFieldKey(customFieldType), CustomFields.builtInCustomFieldKey(customFieldSearcher));
    }

    private <T> void runTest(Supplier<T> initialSetup, Consumer<T> addPermissionToFred, Consumer<T> changePermissionToBob, String[] expectedVisibleIssues) {
        T initialSetupResult = initialSetup.get();
        this.navigation.login("fred");
        this.assertNoIssuesVisible();
        addPermissionToFred.accept(initialSetupResult);
        this.assertIssuesVisible(expectedVisibleIssues);
        this.navigation.login("bob");
        this.assertNoIssuesVisible();
        changePermissionToBob.accept(initialSetupResult);
        this.assertIssuesVisible(expectedVisibleIssues);
    }

    private void setCustomField(String issueKey, String customFieldId, Object value) {
        Long customFieldIdLong = CustomFieldUtils.getCustomFieldId((String)customFieldId);
        this.updateIssueField(issueKey, fields -> fields.customField(customFieldIdLong, value));
    }

    private void setIssueReporter(String issueKey, String username) {
        this.updateIssueField(issueKey, fields -> fields.reporter(ResourceRef.withName((String)username)));
    }

    private void updateIssueField(String issueKey, Consumer<IssueFields> fieldsAdder) {
        IssueFields fields = new IssueFields();
        fieldsAdder.accept(fields);
        this.backdoor.issues().setIssueFields(issueKey, fields);
    }

    private void assertNoIssuesVisible() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTableNotPresent("issuetable");
    }

    private void assertIssuesVisible(String[] issueKeys) {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.assertions.getTableAssertions().getWebTable("issueTable");
        int rowCount = issueTable.getRowCount();
        ArrayList<String> actual = new ArrayList<String>(rowCount);
        int column = 1;
        for (int row = 1; row < rowCount; ++row) {
            actual.add(issueTable.getCellAsText(row, column).trim());
        }
        Assert.assertThat(actual, (Matcher)Matchers.containsInAnyOrder((Object[])issueKeys));
    }
}

