/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.ztests.project.security.ProjectShortcutsClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.PERMISSIONS, Category.BROWSE_PROJECT})
@RestoreBlankInstance
public class TestProjectShortcutsAccess
extends BaseJiraFuncTest {
    @Test
    public void givenAuthenticatedAndProjectDoesNotExistWhenGetShortcutsThenEmptyResponse() {
        ProjectShortcutsClient shortcutsClient = ProjectShortcutsClient.getAuthenticatedShortcutsClient(this.environmentData);
        ProjectShortcutsClient.ProjectShortcut response = shortcutsClient.getShortcutsForProjectKey("NOSUCHPROJ");
        Assert.assertThat(response.getShortcuts(), (Matcher)Matchers.empty());
    }

    @Test
    public void givenAuthenticatedAndProjectExistsWhenGetShortcutsThenNonEmptyResponse() {
        ProjectShortcutsClient shortcutsClient = ProjectShortcutsClient.getAuthenticatedShortcutsClient(this.environmentData);
        ProjectShortcutsClient.ProjectShortcut response = shortcutsClient.getShortcutsForProjectKey("MKY");
        Assert.assertThat(response.getShortcuts(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void givenAuthenticatedAndProjectExistsAndNotBrowseableWhenGetShortcutsThenEmptyResponse() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        ProjectShortcutsClient shortcutsClient = ProjectShortcutsClient.getAuthenticatedShortcutsClient(this.environmentData);
        ProjectShortcutsClient.ProjectShortcut response = shortcutsClient.getShortcutsForProjectKey("MKY");
        Assert.assertThat(response.getShortcuts(), (Matcher)Matchers.empty());
    }

    @Test
    public void givenUnauthenticatedAndProjectExistsAndNotBrowseableWhenGetShortcutsThenEmptyResponse() {
        ProjectShortcutsClient shortcutsClient = ProjectShortcutsClient.getUnauthenticatedShortcutsClient(this.environmentData);
        ProjectShortcutsClient.ProjectShortcut response = shortcutsClient.getShortcutsForProjectKey("MKY");
        Assert.assertThat(response.getShortcuts(), (Matcher)Matchers.empty());
    }

    @Test
    public void givenUnauthenticatedAndProjectExistsAndBrowseableWhenGetShortcutsThenNonEmptyResponse() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        ProjectShortcutsClient shortcutsClient = ProjectShortcutsClient.getUnauthenticatedShortcutsClient(this.environmentData);
        ProjectShortcutsClient.ProjectShortcut response = shortcutsClient.getShortcutsForProjectKey("MKY");
        Assert.assertThat(response.getShortcuts(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

